% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_uSD.R
\name{uSD}
\alias{uSD}
\title{Uncorrected Standard Deviation}
\usage{
uSD(data = NULL, x, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{x}{Vector with numeric observed or predicted values.}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the (uSD) of observed or predicted values.
}
\details{
The uSD is the sample, uncorrected standard deviation. The square root of
the mean of sum of squared differences between vector values with respect to their mean.
It is uncorrected because it is divided by the sample size (n), not n-1.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
uSD(x = X)
}
}
