// Generated by using Rcpp::compileAttributes() -> do not edit by hand
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#ifndef RCPP_meteoland_RCPPEXPORTS_H_GEN_
#define RCPP_meteoland_RCPPEXPORTS_H_GEN_

#include <Rcpp.h>

namespace meteoland {

    using namespace Rcpp;

    namespace {
        void validateSignature(const char* sig) {
            Rcpp::Function require = Rcpp::Environment::base_env()["require"];
            require("meteoland", Rcpp::Named("quietly") = true);
            typedef int(*Ptr_validate)(const char*);
            static Ptr_validate p_validate = (Ptr_validate)
                R_GetCCallable("meteoland", "_meteoland_RcppExport_validate");
            if (!p_validate(sig)) {
                throw Rcpp::function_not_exported(
                    "C++ function with signature '" + std::string(sig) + "' not found in meteoland");
            }
        }
    }

    inline int radiation_julianDay(int year, int month, int day) {
        typedef SEXP(*Ptr_radiation_julianDay)(SEXP,SEXP,SEXP);
        static Ptr_radiation_julianDay p_radiation_julianDay = NULL;
        if (p_radiation_julianDay == NULL) {
            validateSignature("int(*radiation_julianDay)(int,int,int)");
            p_radiation_julianDay = (Ptr_radiation_julianDay)R_GetCCallable("meteoland", "_meteoland_radiation_julianDay");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_julianDay(Shield<SEXP>(Rcpp::wrap(year)), Shield<SEXP>(Rcpp::wrap(month)), Shield<SEXP>(Rcpp::wrap(day)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<int >(rcpp_result_gen);
    }

    inline IntegerVector radiation_dateStringToJulianDays(CharacterVector dateStrings) {
        typedef SEXP(*Ptr_radiation_dateStringToJulianDays)(SEXP);
        static Ptr_radiation_dateStringToJulianDays p_radiation_dateStringToJulianDays = NULL;
        if (p_radiation_dateStringToJulianDays == NULL) {
            validateSignature("IntegerVector(*radiation_dateStringToJulianDays)(CharacterVector)");
            p_radiation_dateStringToJulianDays = (Ptr_radiation_dateStringToJulianDays)R_GetCCallable("meteoland", "_meteoland_radiation_dateStringToJulianDays");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_dateStringToJulianDays(Shield<SEXP>(Rcpp::wrap(dateStrings)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<IntegerVector >(rcpp_result_gen);
    }

    inline double radiation_solarDeclination(int J) {
        typedef SEXP(*Ptr_radiation_solarDeclination)(SEXP);
        static Ptr_radiation_solarDeclination p_radiation_solarDeclination = NULL;
        if (p_radiation_solarDeclination == NULL) {
            validateSignature("double(*radiation_solarDeclination)(int)");
            p_radiation_solarDeclination = (Ptr_radiation_solarDeclination)R_GetCCallable("meteoland", "_meteoland_radiation_solarDeclination");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_solarDeclination(Shield<SEXP>(Rcpp::wrap(J)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double radiation_solarConstant(int J) {
        typedef SEXP(*Ptr_radiation_solarConstant)(SEXP);
        static Ptr_radiation_solarConstant p_radiation_solarConstant = NULL;
        if (p_radiation_solarConstant == NULL) {
            validateSignature("double(*radiation_solarConstant)(int)");
            p_radiation_solarConstant = (Ptr_radiation_solarConstant)R_GetCCallable("meteoland", "_meteoland_radiation_solarConstant");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_solarConstant(Shield<SEXP>(Rcpp::wrap(J)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline NumericVector radiation_sunRiseSet(double latrad, double slorad, double asprad, double delta) {
        typedef SEXP(*Ptr_radiation_sunRiseSet)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_radiation_sunRiseSet p_radiation_sunRiseSet = NULL;
        if (p_radiation_sunRiseSet == NULL) {
            validateSignature("NumericVector(*radiation_sunRiseSet)(double,double,double,double)");
            p_radiation_sunRiseSet = (Ptr_radiation_sunRiseSet)R_GetCCallable("meteoland", "_meteoland_radiation_sunRiseSet");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_sunRiseSet(Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(delta)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline double radiation_solarElevation(double latrad, double delta, double hrad) {
        typedef SEXP(*Ptr_radiation_solarElevation)(SEXP,SEXP,SEXP);
        static Ptr_radiation_solarElevation p_radiation_solarElevation = NULL;
        if (p_radiation_solarElevation == NULL) {
            validateSignature("double(*radiation_solarElevation)(double,double,double)");
            p_radiation_solarElevation = (Ptr_radiation_solarElevation)R_GetCCallable("meteoland", "_meteoland_radiation_solarElevation");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_solarElevation(Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(delta)), Shield<SEXP>(Rcpp::wrap(hrad)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double radiation_daylength(double latrad, double slorad, double asprad, double delta) {
        typedef SEXP(*Ptr_radiation_daylength)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_radiation_daylength p_radiation_daylength = NULL;
        if (p_radiation_daylength == NULL) {
            validateSignature("double(*radiation_daylength)(double,double,double,double)");
            p_radiation_daylength = (Ptr_radiation_daylength)R_GetCCallable("meteoland", "_meteoland_radiation_daylength");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_daylength(Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(delta)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double radiation_daylengthseconds(double latrad, double slorad, double asprad, double delta) {
        typedef SEXP(*Ptr_radiation_daylengthseconds)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_radiation_daylengthseconds p_radiation_daylengthseconds = NULL;
        if (p_radiation_daylengthseconds == NULL) {
            validateSignature("double(*radiation_daylengthseconds)(double,double,double,double)");
            p_radiation_daylengthseconds = (Ptr_radiation_daylengthseconds)R_GetCCallable("meteoland", "_meteoland_radiation_daylengthseconds");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_daylengthseconds(Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(delta)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double radiation_potentialRadiation(double solarConstant, double latrad, double slorad, double asprad, double delta) {
        typedef SEXP(*Ptr_radiation_potentialRadiation)(SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_radiation_potentialRadiation p_radiation_potentialRadiation = NULL;
        if (p_radiation_potentialRadiation == NULL) {
            validateSignature("double(*radiation_potentialRadiation)(double,double,double,double,double)");
            p_radiation_potentialRadiation = (Ptr_radiation_potentialRadiation)R_GetCCallable("meteoland", "_meteoland_radiation_potentialRadiation");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_potentialRadiation(Shield<SEXP>(Rcpp::wrap(solarConstant)), Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(delta)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double radiation_solarRadiation(double solarConstant, double latrad, double elevation, double slorad, double asprad, double delta, double diffTemp, double diffTempMonth, double vpa, double precipitation) {
        typedef SEXP(*Ptr_radiation_solarRadiation)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_radiation_solarRadiation p_radiation_solarRadiation = NULL;
        if (p_radiation_solarRadiation == NULL) {
            validateSignature("double(*radiation_solarRadiation)(double,double,double,double,double,double,double,double,double,double)");
            p_radiation_solarRadiation = (Ptr_radiation_solarRadiation)R_GetCCallable("meteoland", "_meteoland_radiation_solarRadiation");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_solarRadiation(Shield<SEXP>(Rcpp::wrap(solarConstant)), Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(elevation)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(delta)), Shield<SEXP>(Rcpp::wrap(diffTemp)), Shield<SEXP>(Rcpp::wrap(diffTempMonth)), Shield<SEXP>(Rcpp::wrap(vpa)), Shield<SEXP>(Rcpp::wrap(precipitation)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline NumericVector radiation_directDiffuseInstant(double solarConstant, double latrad, double delta, double hrad, double R_p, double R_s, bool clearday) {
        typedef SEXP(*Ptr_radiation_directDiffuseInstant)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_radiation_directDiffuseInstant p_radiation_directDiffuseInstant = NULL;
        if (p_radiation_directDiffuseInstant == NULL) {
            validateSignature("NumericVector(*radiation_directDiffuseInstant)(double,double,double,double,double,double,bool)");
            p_radiation_directDiffuseInstant = (Ptr_radiation_directDiffuseInstant)R_GetCCallable("meteoland", "_meteoland_radiation_directDiffuseInstant");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_directDiffuseInstant(Shield<SEXP>(Rcpp::wrap(solarConstant)), Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(delta)), Shield<SEXP>(Rcpp::wrap(hrad)), Shield<SEXP>(Rcpp::wrap(R_p)), Shield<SEXP>(Rcpp::wrap(R_s)), Shield<SEXP>(Rcpp::wrap(clearday)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline DataFrame radiation_directDiffuseDay(double solarConstant, double latrad, double delta, double R_s, bool clearday, int nsteps = 24) {
        typedef SEXP(*Ptr_radiation_directDiffuseDay)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_radiation_directDiffuseDay p_radiation_directDiffuseDay = NULL;
        if (p_radiation_directDiffuseDay == NULL) {
            validateSignature("DataFrame(*radiation_directDiffuseDay)(double,double,double,double,bool,int)");
            p_radiation_directDiffuseDay = (Ptr_radiation_directDiffuseDay)R_GetCCallable("meteoland", "_meteoland_radiation_directDiffuseDay");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_directDiffuseDay(Shield<SEXP>(Rcpp::wrap(solarConstant)), Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(delta)), Shield<SEXP>(Rcpp::wrap(R_s)), Shield<SEXP>(Rcpp::wrap(clearday)), Shield<SEXP>(Rcpp::wrap(nsteps)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<DataFrame >(rcpp_result_gen);
    }

    inline double radiation_skyLongwaveRadiation(double Tair, double vpa, double c = 0) {
        typedef SEXP(*Ptr_radiation_skyLongwaveRadiation)(SEXP,SEXP,SEXP);
        static Ptr_radiation_skyLongwaveRadiation p_radiation_skyLongwaveRadiation = NULL;
        if (p_radiation_skyLongwaveRadiation == NULL) {
            validateSignature("double(*radiation_skyLongwaveRadiation)(double,double,double)");
            p_radiation_skyLongwaveRadiation = (Ptr_radiation_skyLongwaveRadiation)R_GetCCallable("meteoland", "_meteoland_radiation_skyLongwaveRadiation");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_skyLongwaveRadiation(Shield<SEXP>(Rcpp::wrap(Tair)), Shield<SEXP>(Rcpp::wrap(vpa)), Shield<SEXP>(Rcpp::wrap(c)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double radiation_outgoingLongwaveRadiation(double solarConstant, double latrad, double elevation, double slorad, double asprad, double delta, double vpa, double tmin, double tmax, double R_s) {
        typedef SEXP(*Ptr_radiation_outgoingLongwaveRadiation)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_radiation_outgoingLongwaveRadiation p_radiation_outgoingLongwaveRadiation = NULL;
        if (p_radiation_outgoingLongwaveRadiation == NULL) {
            validateSignature("double(*radiation_outgoingLongwaveRadiation)(double,double,double,double,double,double,double,double,double,double)");
            p_radiation_outgoingLongwaveRadiation = (Ptr_radiation_outgoingLongwaveRadiation)R_GetCCallable("meteoland", "_meteoland_radiation_outgoingLongwaveRadiation");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_outgoingLongwaveRadiation(Shield<SEXP>(Rcpp::wrap(solarConstant)), Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(elevation)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(delta)), Shield<SEXP>(Rcpp::wrap(vpa)), Shield<SEXP>(Rcpp::wrap(tmin)), Shield<SEXP>(Rcpp::wrap(tmax)), Shield<SEXP>(Rcpp::wrap(R_s)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double radiation_netRadiation(double solarConstant, double latrad, double elevation, double slorad, double asprad, double delta, double vpa, double tmin, double tmax, double R_s, double alpha = 0.08) {
        typedef SEXP(*Ptr_radiation_netRadiation)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_radiation_netRadiation p_radiation_netRadiation = NULL;
        if (p_radiation_netRadiation == NULL) {
            validateSignature("double(*radiation_netRadiation)(double,double,double,double,double,double,double,double,double,double,double)");
            p_radiation_netRadiation = (Ptr_radiation_netRadiation)R_GetCCallable("meteoland", "_meteoland_radiation_netRadiation");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_radiation_netRadiation(Shield<SEXP>(Rcpp::wrap(solarConstant)), Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(elevation)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(delta)), Shield<SEXP>(Rcpp::wrap(vpa)), Shield<SEXP>(Rcpp::wrap(tmin)), Shield<SEXP>(Rcpp::wrap(tmax)), Shield<SEXP>(Rcpp::wrap(R_s)), Shield<SEXP>(Rcpp::wrap(alpha)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline NumericVector _potentialRadiationSeries(double latrad, double slorad, double asprad, NumericVector J) {
        typedef SEXP(*Ptr__potentialRadiationSeries)(SEXP,SEXP,SEXP,SEXP);
        static Ptr__potentialRadiationSeries p__potentialRadiationSeries = NULL;
        if (p__potentialRadiationSeries == NULL) {
            validateSignature("NumericVector(*_potentialRadiationSeries)(double,double,double,NumericVector)");
            p__potentialRadiationSeries = (Ptr__potentialRadiationSeries)R_GetCCallable("meteoland", "_meteoland__potentialRadiationSeries");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p__potentialRadiationSeries(Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(J)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector _potentialRadiationPoints(double latrad, NumericVector slorad, NumericVector asprad, int J) {
        typedef SEXP(*Ptr__potentialRadiationPoints)(SEXP,SEXP,SEXP,SEXP);
        static Ptr__potentialRadiationPoints p__potentialRadiationPoints = NULL;
        if (p__potentialRadiationPoints == NULL) {
            validateSignature("NumericVector(*_potentialRadiationPoints)(double,NumericVector,NumericVector,int)");
            p__potentialRadiationPoints = (Ptr__potentialRadiationPoints)R_GetCCallable("meteoland", "_meteoland__potentialRadiationPoints");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p__potentialRadiationPoints(Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(J)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector _radiationSeries(double latrad, double elevation, double slorad, double asprad, NumericVector J, NumericVector diffTemp, NumericVector diffTempMonth, NumericVector VP, NumericVector P) {
        typedef SEXP(*Ptr__radiationSeries)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr__radiationSeries p__radiationSeries = NULL;
        if (p__radiationSeries == NULL) {
            validateSignature("NumericVector(*_radiationSeries)(double,double,double,double,NumericVector,NumericVector,NumericVector,NumericVector,NumericVector)");
            p__radiationSeries = (Ptr__radiationSeries)R_GetCCallable("meteoland", "_meteoland__radiationSeries");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p__radiationSeries(Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(elevation)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(J)), Shield<SEXP>(Rcpp::wrap(diffTemp)), Shield<SEXP>(Rcpp::wrap(diffTempMonth)), Shield<SEXP>(Rcpp::wrap(VP)), Shield<SEXP>(Rcpp::wrap(P)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector _radiationPoints(NumericVector latrad, NumericVector elevation, NumericVector slorad, NumericVector asprad, int J, NumericVector diffTemp, NumericVector diffTempMonth, NumericVector VP, NumericVector P) {
        typedef SEXP(*Ptr__radiationPoints)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr__radiationPoints p__radiationPoints = NULL;
        if (p__radiationPoints == NULL) {
            validateSignature("NumericVector(*_radiationPoints)(NumericVector,NumericVector,NumericVector,NumericVector,int,NumericVector,NumericVector,NumericVector,NumericVector)");
            p__radiationPoints = (Ptr__radiationPoints)R_GetCCallable("meteoland", "_meteoland__radiationPoints");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p__radiationPoints(Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(elevation)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(J)), Shield<SEXP>(Rcpp::wrap(diffTemp)), Shield<SEXP>(Rcpp::wrap(diffTempMonth)), Shield<SEXP>(Rcpp::wrap(VP)), Shield<SEXP>(Rcpp::wrap(P)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline double utils_saturationVP(double temperature) {
        typedef SEXP(*Ptr_utils_saturationVP)(SEXP);
        static Ptr_utils_saturationVP p_utils_saturationVP = NULL;
        if (p_utils_saturationVP == NULL) {
            validateSignature("double(*utils_saturationVP)(double)");
            p_utils_saturationVP = (Ptr_utils_saturationVP)R_GetCCallable("meteoland", "_meteoland_utils_saturationVP");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_utils_saturationVP(Shield<SEXP>(Rcpp::wrap(temperature)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double utils_averageDailyVP(double Tmin, double Tmax, double RHmin, double RHmax) {
        typedef SEXP(*Ptr_utils_averageDailyVP)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_utils_averageDailyVP p_utils_averageDailyVP = NULL;
        if (p_utils_averageDailyVP == NULL) {
            validateSignature("double(*utils_averageDailyVP)(double,double,double,double)");
            p_utils_averageDailyVP = (Ptr_utils_averageDailyVP)R_GetCCallable("meteoland", "_meteoland_utils_averageDailyVP");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_utils_averageDailyVP(Shield<SEXP>(Rcpp::wrap(Tmin)), Shield<SEXP>(Rcpp::wrap(Tmax)), Shield<SEXP>(Rcpp::wrap(RHmin)), Shield<SEXP>(Rcpp::wrap(RHmax)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double utils_atmosphericPressure(double elevation) {
        typedef SEXP(*Ptr_utils_atmosphericPressure)(SEXP);
        static Ptr_utils_atmosphericPressure p_utils_atmosphericPressure = NULL;
        if (p_utils_atmosphericPressure == NULL) {
            validateSignature("double(*utils_atmosphericPressure)(double)");
            p_utils_atmosphericPressure = (Ptr_utils_atmosphericPressure)R_GetCCallable("meteoland", "_meteoland_utils_atmosphericPressure");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_utils_atmosphericPressure(Shield<SEXP>(Rcpp::wrap(elevation)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double utils_airDensity(double temperature, double Patm) {
        typedef SEXP(*Ptr_utils_airDensity)(SEXP,SEXP);
        static Ptr_utils_airDensity p_utils_airDensity = NULL;
        if (p_utils_airDensity == NULL) {
            validateSignature("double(*utils_airDensity)(double,double)");
            p_utils_airDensity = (Ptr_utils_airDensity)R_GetCCallable("meteoland", "_meteoland_utils_airDensity");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_utils_airDensity(Shield<SEXP>(Rcpp::wrap(temperature)), Shield<SEXP>(Rcpp::wrap(Patm)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double utils_averageDaylightTemperature(double Tmin, double Tmax) {
        typedef SEXP(*Ptr_utils_averageDaylightTemperature)(SEXP,SEXP);
        static Ptr_utils_averageDaylightTemperature p_utils_averageDaylightTemperature = NULL;
        if (p_utils_averageDaylightTemperature == NULL) {
            validateSignature("double(*utils_averageDaylightTemperature)(double,double)");
            p_utils_averageDaylightTemperature = (Ptr_utils_averageDaylightTemperature)R_GetCCallable("meteoland", "_meteoland_utils_averageDaylightTemperature");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_utils_averageDaylightTemperature(Shield<SEXP>(Rcpp::wrap(Tmin)), Shield<SEXP>(Rcpp::wrap(Tmax)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double utils_latentHeatVaporisation(double temperature) {
        typedef SEXP(*Ptr_utils_latentHeatVaporisation)(SEXP);
        static Ptr_utils_latentHeatVaporisation p_utils_latentHeatVaporisation = NULL;
        if (p_utils_latentHeatVaporisation == NULL) {
            validateSignature("double(*utils_latentHeatVaporisation)(double)");
            p_utils_latentHeatVaporisation = (Ptr_utils_latentHeatVaporisation)R_GetCCallable("meteoland", "_meteoland_utils_latentHeatVaporisation");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_utils_latentHeatVaporisation(Shield<SEXP>(Rcpp::wrap(temperature)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double utils_latentHeatVaporisationMol(double temperature) {
        typedef SEXP(*Ptr_utils_latentHeatVaporisationMol)(SEXP);
        static Ptr_utils_latentHeatVaporisationMol p_utils_latentHeatVaporisationMol = NULL;
        if (p_utils_latentHeatVaporisationMol == NULL) {
            validateSignature("double(*utils_latentHeatVaporisationMol)(double)");
            p_utils_latentHeatVaporisationMol = (Ptr_utils_latentHeatVaporisationMol)R_GetCCallable("meteoland", "_meteoland_utils_latentHeatVaporisationMol");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_utils_latentHeatVaporisationMol(Shield<SEXP>(Rcpp::wrap(temperature)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double utils_psychrometricConstant(double temperature, double Patm) {
        typedef SEXP(*Ptr_utils_psychrometricConstant)(SEXP,SEXP);
        static Ptr_utils_psychrometricConstant p_utils_psychrometricConstant = NULL;
        if (p_utils_psychrometricConstant == NULL) {
            validateSignature("double(*utils_psychrometricConstant)(double,double)");
            p_utils_psychrometricConstant = (Ptr_utils_psychrometricConstant)R_GetCCallable("meteoland", "_meteoland_utils_psychrometricConstant");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_utils_psychrometricConstant(Shield<SEXP>(Rcpp::wrap(temperature)), Shield<SEXP>(Rcpp::wrap(Patm)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double utils_saturationVaporPressureCurveSlope(double temperature) {
        typedef SEXP(*Ptr_utils_saturationVaporPressureCurveSlope)(SEXP);
        static Ptr_utils_saturationVaporPressureCurveSlope p_utils_saturationVaporPressureCurveSlope = NULL;
        if (p_utils_saturationVaporPressureCurveSlope == NULL) {
            validateSignature("double(*utils_saturationVaporPressureCurveSlope)(double)");
            p_utils_saturationVaporPressureCurveSlope = (Ptr_utils_saturationVaporPressureCurveSlope)R_GetCCallable("meteoland", "_meteoland_utils_saturationVaporPressureCurveSlope");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_utils_saturationVaporPressureCurveSlope(Shield<SEXP>(Rcpp::wrap(temperature)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double penman(double latrad, double elevation, double slorad, double asprad, int J, double Tmin, double Tmax, double RHmin, double RHmax, double R_s, double u, double z = 2.0, double z0 = 0.001, double alpha = 0.08, String windfun = "1956") {
        typedef SEXP(*Ptr_penman)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_penman p_penman = NULL;
        if (p_penman == NULL) {
            validateSignature("double(*penman)(double,double,double,double,int,double,double,double,double,double,double,double,double,double,String)");
            p_penman = (Ptr_penman)R_GetCCallable("meteoland", "_meteoland_penman");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_penman(Shield<SEXP>(Rcpp::wrap(latrad)), Shield<SEXP>(Rcpp::wrap(elevation)), Shield<SEXP>(Rcpp::wrap(slorad)), Shield<SEXP>(Rcpp::wrap(asprad)), Shield<SEXP>(Rcpp::wrap(J)), Shield<SEXP>(Rcpp::wrap(Tmin)), Shield<SEXP>(Rcpp::wrap(Tmax)), Shield<SEXP>(Rcpp::wrap(RHmin)), Shield<SEXP>(Rcpp::wrap(RHmax)), Shield<SEXP>(Rcpp::wrap(R_s)), Shield<SEXP>(Rcpp::wrap(u)), Shield<SEXP>(Rcpp::wrap(z)), Shield<SEXP>(Rcpp::wrap(z0)), Shield<SEXP>(Rcpp::wrap(alpha)), Shield<SEXP>(Rcpp::wrap(windfun)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline double penmanmonteith(double rc, double elevation, double Tmin, double Tmax, double RHmin, double RHmax, double Rn, double u = NA_REAL) {
        typedef SEXP(*Ptr_penmanmonteith)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_penmanmonteith p_penmanmonteith = NULL;
        if (p_penmanmonteith == NULL) {
            validateSignature("double(*penmanmonteith)(double,double,double,double,double,double,double,double)");
            p_penmanmonteith = (Ptr_penmanmonteith)R_GetCCallable("meteoland", "_meteoland_penmanmonteith");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_penmanmonteith(Shield<SEXP>(Rcpp::wrap(rc)), Shield<SEXP>(Rcpp::wrap(elevation)), Shield<SEXP>(Rcpp::wrap(Tmin)), Shield<SEXP>(Rcpp::wrap(Tmax)), Shield<SEXP>(Rcpp::wrap(RHmin)), Shield<SEXP>(Rcpp::wrap(RHmax)), Shield<SEXP>(Rcpp::wrap(Rn)), Shield<SEXP>(Rcpp::wrap(u)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

}

#endif // RCPP_meteoland_RCPPEXPORTS_H_GEN_
