% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.limitmeta.R
\name{print.summary.limitmeta}
\alias{print.summary.limitmeta}
\title{Print detailed results for limit meta-analysis}
\usage{
\method{print}{summary.limitmeta}(
  x,
  sortvar,
  backtransf = x$backtransf,
  digits = gs("digits"),
  big.mark = gs("big.mark"),
  truncate,
  text.truncate = "*** Output truncated ***",
  ...
)
}
\arguments{
\item{x}{An object of class \code{summary.limitmeta}}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as \code{x$TE}).}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If
\code{backtransf=TRUE} (default), results for \code{sm="OR"} are
printed as odds ratios rather than log odds ratio, for example.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{big.mark}{A character used as thousands separator.}

\item{truncate}{An optional vector used to truncate the printout of
results for individual studies (must be a logical vector of same
length as \code{x$TE} or contain numerical values).}

\item{text.truncate}{A character string printed if study results
were truncated from the printout.}

\item{\dots}{Additional arguments which are
passed on to \code{print.limitmeta} called internally.}
}
\description{
Print method for objects of class \code{summary.limitmeta}.

This function prints the main results of a limit meta-analysis
(Rücker et al., 2011) as well as the following study information:

\itemize{
\item Effect estimate with confidence interval
\item Shrunken effect estimates with confidence interval
}
}
\examples{
data(Moore1998)
m1 <- metabin(succ.e, nobs.e, succ.c, nobs.c,
  data = Moore1998, sm = "OR", method = "Inverse")

print(summary(limitmeta(m1)), digits = 2)

}
\seealso{
\code{\link{limitmeta}}, \code{\link{summary.limitmeta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{print}
