% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncatedPearson.R
\name{truncatedPearson}
\alias{truncatedPearson}
\title{Truncated-Pearsons' test}
\usage{
truncatedPearson(p, alpha.tilde = 1)
}
\arguments{
\item{p}{one-sided p-values of the individual studies for testing one-sided alternative based on z-test.}

\item{alpha.tilde}{truncartion threshold for truncated-Pearson test. Use alpha.tilde = 1 for ordinary Pearsons' test for combining p-values.}
}
\value{
A 'list' containing the following quantities: 
\itemize{ A list containing results of truncated-Pearson's test, as follows: 
  \item{chisq: }{Pearson test statistic }
  \item{df: }{degrees of freedom of truncated-Pearson statistic }
  \item{rvalue: }{p-value of the test }
  \item{validp: }{p-values used in the test. }
}
}
\description{
Apply Truncated-Pearsons' test or ordinary Pearsons' test on one-sided p-values.
}
\examples{
truncatedPearson( p = c( 0.001 , 0.01 , 0.1  ) , alpha.tilde = 1 )
truncatedPearson( p = c( 0.001 , 0.01 , 0.1  ) , alpha.tilde = 0.05 )
}
