% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack.R
\name{unpack.data.frame}
\alias{unpack.data.frame}
\title{Express Scalar Column Attributes as Column Metadata}
\usage{
\method{unpack}{data.frame}(x, meta = getOption("meta", "meta"),
  position = 1L, ignore = c("class", "levels"), ...)
}
\arguments{
\item{x}{data.frame}

\item{meta}{column in result giving names of attributes}

\item{position}{1 (top-left), 2 (top-right), 3 (bottom-right), or 4 (bottom-left)}

\item{ignore}{character: attributes to ignore}

\item{...}{ignored arguments}
}
\value{
data.frame

data.frame with all columns of class character
}
\description{
Expresses scalar column attributes as column metadata (row values).  Column with name \code{meta} is created to hold names of attributes, if any. A transposed table (sorted by attribute name) of scalar column attribute values (coerced to character) is bound to the existing data.frame (the attributes themselves are removed from columns).  Bind position is controlled by \code{position} such that the intersection of new rows and column occurs in the corresponding corner, numbered clockwise from top-left. Resulting column classes are character. It is an error if \code{meta} is already in \code{names(x)}.
}
\seealso{
Other pack: \code{\link{pack.data.frame}},
  \code{\link{pack}}, \code{\link{unpack}}

Other methods: \code{\link{axislabel.data.frame}},
  \code{\link{boxplot.data.frame}},
  \code{\link{categorical.data.frame}},
  \code{\link{corsplom.data.frame}},
  \code{\link{densplot.data.frame}},
  \code{\link{metaplot.data.frame}},
  \code{\link{pack.data.frame}},
  \code{\link{plot.metaplot_gtable}},
  \code{\link{print.metaplot_gtable}},
  \code{\link{scatter.data.frame}}
}
