% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box.R
\name{boxplot.data.frame}
\alias{boxplot.data.frame}
\title{Boxplot Method for Data Frame}
\usage{
\method{boxplot}{data.frame}(x, ..., log = FALSE, horizontal = NULL,
  main = FALSE, crit = 1.3, ref = NULL, nobs = FALSE, na.rm = TRUE,
  xlab = NULL, ylab = NULL, aspect = 1, fun = getOption("metaplot_box",
  "boxplot_data_frame"))
}
\arguments{
\item{x}{data.frame}

\item{...}{unquoted names of two items to plot (y , x)}

\item{log}{whether to log transform numeric variable (auto-selected if NULL)}

\item{horizontal}{whether box/whisker axis should be horizontal (numeric x, categorical y)}

\item{main}{logical: whether to include title indicating x and y items; or a substitute title or NULL}

\item{crit}{if log is NULL, log-transform if mean/median ratio for non-missing x is greater than this value}

\item{ref}{optional reference line on numeric axis}

\item{nobs}{whether to include the number of observations under the category label}

\item{na.rm}{whether to remove data points with one or more missing coordinates}

\item{xlab}{passed to \code{\link[lattice]{bwplot}}}

\item{ylab}{passed to \code{\link[lattice]{bwplot}}}

\item{aspect}{passed to \code{\link[lattice]{bwplot}}}

\item{fun}{function that does the actual plotting}
}
\description{
Boxplot for data.frame.  Uses nonstandard evaluation.
}
\examples{
boxplot(Theoph,'Subject','conc')
boxplot(Theoph,Subject,conc)
boxplot(Theoph,conc,Subject)
}
\seealso{
Other bivariate functions: \code{\link{boxplot_data_frame}}

Other boxplot: \code{\link{boxplot.folded}}
}
