% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaplot.R
\name{scatter}
\alias{scatter}
\alias{scatter.data.frame}
\alias{scatter.folded}
\title{Scatterplot}
\usage{
scatter(x, ...)

\method{scatter}{data.frame}(x, .y, .x, groups = NULL, ..., ylog = FALSE,
  xlog = FALSE, yref = NULL, xref = NULL, ysmooth = FALSE,
  xsmooth = FALSE, cols = 3, density = FALSE, iso = FALSE,
  main = FALSE, corr = FALSE, group_codes = NULL, crit = 1.3,
  na.rm = TRUE, fit = conf, conf = FALSE, loc = 0, msg = "metastats",
  panel = metapanel)

\method{scatter}{folded}(x, .y, .x, groups = NULL, ..., ylog = FALSE,
  xlog = FALSE, yref = NULL, xref = NULL, ysmooth = FALSE,
  xsmooth = FALSE, cols = 3, density = FALSE, iso = FALSE,
  main = FALSE, corr = FALSE, crit = 1.3, na.rm = TRUE, fit = conf,
  conf = FALSE, loc = 0, msg = "metastats", panel = metapanel)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}

\item{.y}{y axis item}

\item{.x}{x axis item}

\item{groups}{optional grouping item}

\item{ylog}{log transform y axis (guessed if missing)}

\item{xlog}{log transform x axis (guessed if missing)}

\item{yref}{reference line from y axis}

\item{xref}{reference line from x axis}

\item{ysmooth}{supply loess smooth of y on x}

\item{xsmooth}{supply loess smmoth of x on y}

\item{cols}{suggested columns for auto.key}

\item{density}{plot point density instead of points (ignored if \code{groups} is supplied)}

\item{iso}{use isometric axes with line of unity}

\item{main}{logical: whether to construct a default title; or a substitute title or NULL}

\item{corr}{append Pearson correlation coefficient to default title (only if main is \code{TRUE})}

\item{group_codes}{append these to group values for display purposes}

\item{crit}{if ylog or xlog missing, log transform if mean/median ratio for non-missing values is greater than crit}

\item{na.rm}{whether to remove data points with one or more missing coordinates}

\item{fit}{draw a linear fit of y ~ x}

\item{conf}{logical, or width for a confidence region around a linear fit; passed to \code{\link{region}}; \code{TRUE} defaults to 95 percent confidence interval}

\item{loc}{where to print statistics on a panel}

\item{msg}{a function to print text on a panel: called with x values, y values, and \dots.}

\item{panel}{name or definition of panel function}
}
\description{
Scatterplot.

Scatterplot for class 'data.frame'. Extra arguments passed to \code{\link{region}}.

Scatterplot for class 'folded'.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: data.frame method

\item \code{folded}: folded method
}}

\seealso{
\code{\link{metapanel}}

Other generic functions: \code{\link{axislabel}},
  \code{\link{continuous}}, \code{\link{corsplom}},
  \code{\link{dens}}, \code{\link{guide}},
  \code{\link{label}}, \code{\link{metaplot}},
  \code{\link{overlay}}

Other bivariate plots: \code{\link{boxplot}},
  \code{\link{metaplot}}

Other bivariate plots: \code{\link{boxplot}},
  \code{\link{metaplot}}
}
