% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valmeta.r
\name{valmeta}
\alias{valmeta}
\title{Meta-analysis of prediction model performance}
\usage{
valmeta(
  measure = "cstat",
  cstat,
  cstat.se,
  cstat.cilb,
  cstat.ciub,
  cstat.cilv,
  sd.LP,
  OE,
  OE.se,
  OE.cilb,
  OE.ciub,
  OE.cilv,
  citl,
  citl.se,
  N,
  O,
  E,
  Po,
  Po.se,
  Pe,
  data,
  method = "REML",
  test = "knha",
  ret.fit = FALSE,
  verbose = FALSE,
  slab,
  n.chains = 4,
  pars,
  ...
)
}
\arguments{
\item{measure}{A character string indicating which summary performance measure should be calculated. Options are
\code{"cstat"} (meta-analysis of the concordance statistic) and \code{"OE"} 
(meta-analysis of the total observed-expected ratio). See `Details' for more information.}

\item{cstat}{Optional vector with the estimated c-statistic for each valiation}

\item{cstat.se}{Optional vector with the standard error of the estimated c-statistics}

\item{cstat.cilb}{Optional vector to specify the lower limits of the confidence interval.}

\item{cstat.ciub}{Optional vector to specify the upper limits of the confidence interval.}

\item{cstat.cilv}{Optional vector to specify the levels of aformentioned confidence interval limits. 
(default: 0.95, which corresponds to the 95\% confidence interval).}

\item{sd.LP}{Optional vector with the standard deviation of the linear predictor (prognostic index)}

\item{OE}{Optional vector with the estimated ratio of total observed versus total expected events}

\item{OE.se}{Optional vector with the standard errors of the estimated O:E ratios}

\item{OE.cilb}{Optional vector to specify the lower limits of the confidence interval for \code{OE}.}

\item{OE.ciub}{Optional vector to specify the upper limits of the confidence interval for \code{OE}.}

\item{OE.cilv}{Optional vector to specify the levels of aformentioned confidence interval limits. 
(default: 0.95, which corresponds to the 95\% confidence interval).}

\item{citl}{Optional vector with the estimated calibration-in-the-large for each valiation}

\item{citl.se}{Optional vector with the standard error of the estimated calibration-in-the-large statistics}

\item{N}{Optional vector with the total number of participants for each valiation}

\item{O}{Optional vector with the total number of observed events for each valiation
(if specified, during time \code{t.val})}

\item{E}{Optional vector with the total number of expected events for each valiation 
(if specified, during time \code{t.val})}

\item{Po}{Optional vector with the (cumulative) observed event probability for each valiation
(if specified, during time \code{t.val})}

\item{Po.se}{Optional vector with the standard errors of \code{Po}.}

\item{Pe}{Optional vector with the (cumulative) expected event probability for each validation
(if specified, during time \code{t.val})}

\item{data}{optional data frame containing the variables given to the arguments above.}

\item{method}{Character string specifying whether a fixed- or a random-effects model should be fitted. 
A fixed-effects model is fitted when using \code{method="FE"}. Random-effects models are fitted by setting method 
equal to one of the following: \code{"REML"} (Default), \code{"DL"}, \code{"HE"}, \code{"SJ"}, \code{"ML"}, 
\code{"EB"}, \code{"HS"}, \code{"GENQ"} or \code{"BAYES"}. See 'Details'.}

\item{test}{Optional character string specifying how test statistics and confidence intervals for the fixed effects 
should be computed. By default (\code{test="knha"}), the method by Knapp and Hartung (2003) is used for 
adjusting test statistics and confidence intervals. Type '\code{?rma}' for more details.}

\item{ret.fit}{logical indicating whether the full results from the fitted model should also be returned.}

\item{verbose}{If TRUE then messages generated during the fitting process will be displayed.}

\item{slab}{Optional vector specifying the label for each study}

\item{n.chains}{Optional numeric specifying the number of chains to use in the Gibbs sampler 
(if \code{method="BAYES"}). More chains will improve the sensitivity of the convergence diagnostic, but will 
cause the simulation to run more slowly. The default number of chains is 4.}

\item{pars}{A list with additional arguments.  See 'Details' for more information. The following parameters configure the MCMC sampling procedure:
\code{hp.mu.mean} (mean of the prior distribution of the random effects model, defaults to 0), 
\code{hp.mu.var} (variance of the prior distribution of the random effects model, defaults to 1E6), 
\code{hp.tau.min} (minimum value for the between-study standard deviation, defaults to 0), 
\code{hp.tau.max} (maximum value for the between-study standard deviation, defaults to 2), 
\code{hp.tau.sigma} (standard deviation of the prior distribution for the between-study standard-deviation), 
\code{hp.tau.dist} (prior distribution for the between-study standard-deviation. Defaults to \code{"dunif"}), 
\code{hp.tau.df} (degrees of freedom for the prior distribution for the between-study standard-deviation. 
Defaults to 3). Other arguments are \code{method.restore.c.se} (method for restoring missing estimates for the standard error 
of the c-statistic. See \code{\link{ccalc}} for more information), \code{model.cstat} (The likelihood/link for modeling 
the c-statistic; see "Details"), \code{model.oe} (The likelihood/link for modeling the O:E ratio; see "Details")}

\item{\ldots}{Additional arguments that are passed to \pkg{rma} or \pkg{runjags} (if \code{method="BAYES"}).}
}
\value{
An object of class \code{valmeta} with the following elements:
\describe{
 \item{"data"}{array with (transformed) data used for meta-analysis, and method(s) used for restoring missing information. }
 \item{"measure"}{character string specifying the performance measure that has been meta-analysed.}
 \item{"method"}{character string specifying the meta-analysis method.}
 \item{"model"}{character string specifying the meta-analysis model (link function).}
 \item{"est"}{summary estimate for the performance statistic. For Bayesian meta-analysis, the posterior median is returned.}
 \item{"ci.lb"}{lower bound of the confidence (or credibility) interval of the summary performance estimate.}
 \item{"ci.ub"}{upper bound of the confidence (or credibility) interval of the summary performance estimate.}
 \item{"pi.lb"}{lower bound of the (approximate) prediction interval of the summary performance estimate.}
 \item{"pi.ub"}{upper bound of the (approximate) prediction interval of the summary performance estimate.}
 \item{"fit"}{the full results from the fitted model. Only defined if \code{ret.fit = TRUE}.}
 \item{"slab"}{vector specifying the label of each study.}
}
}
\description{
This function provides summary estimates for the concordance statistic, the total observed-expected ratio 
or the calibration slope. Where appropriate, data transformations are applied and missing information 
is derived from available quantities. Unless specified otherwise, all meta-analysis models assume random effects 
and are fitted using restricted maximum likelihood estimation with the \pkg{metafor} package (Viechtbauer 2010).  
Further, confidence intervals for the average performance are based on the Hartung-Knapp-Sidik-Jonkman method. 
When conducting a Bayesian meta-analysis, the R packages \pkg{runjags} and \pkg{rjags} must be installed.
}
\details{
\subsection{Meta-analysis of the concordance statistic}{
A summary estimate for the concorcance (c-) statistic can be obtained by specifying \code{measure="cstat"}.
The c-statistic is a measure of discrimination, and indicates the ability of a prediction model to 
distinguish between patients developing and not developing the outcome. The c-statistic typically ranges 
from 0.5 (no discriminative ability) to 1 (perfect discriminative ability). When missing, the c-statistic 
and/or its standard error are derived from other reported information. 
See \code{\link{ccalc}} for more information.

By default, it is assumed that the logit of the c-statistic is Normally distributed within and across studies
(\code{pars$model.cstat = "normal/logit"}). Alternatively, it is possible to assume that the raw c-statistic 
is Normally distributed across studies \code{pars$model.cstat = "normal/identity"}. 
} 

\subsection{Meta-analysis of the total observed versus expected ratio}{
A summary estimate for the total observed versus expected (O:E) ratio can be obtained by specifying
\code{measure="OE"}. The total O:E ratio provides a rough indication of the overall model calibration (across the 
entire range of predicted risks). When missing, the total O:E ratio and/or its standard error are derived from other 
reported information. See \code{\link{oecalc}} for more information.

For frequentist meta-analysis, within-study variation can either be modeled using a Normal (\code{model.oe = "normal/log"} 
or \code{model.oe = "normal/identity"}) or a Poisson distribution (\code{model.oe = "normal/log"}). 

When performing a Bayesian meta-analysis, all data are modeled using a one-stage random effects (hierarchical related regression) model.
In particular, a binomial distribution (if \code{O}, \code{E} and \code{N} is known), a Poisson distribution 
(if only \code{O} and \code{E} are known) or a Normal distribution (if \code{OE} and \code{OE.se} or \code{OE.95CI} are known) is selected separately for each study.

}

\subsection{Bayesian meta-analysis}{
All Bayesian meta-analysis models assume random effects by default. Results are based on the posterior median. 
Credibility and prediction intervals are directly obtained from the corresponding posterior quantiles.

The prior distribution for the (transformed) summary estimate is always modeled using a Normal distribution, 
with mean \code{hp.mu.mean} (defaults to 0) and variance 
\code{hp.mu.var} (defaults to 1E6). For meta-analysis of the total O:E ratio, the maximum value for \code{hp.mu.var} is 100.

By default, the prior distribution for the between-study standard deviation is modeled using a uniform distribution 
(\code{hp.tau.dist="dunif"}), with boundaries \code{hp.tau.min} and \code{hp.tau.max}. Alternatively, it is possible
to specify a truncated Student-t distribution (\code{hp.tau.dist="dhalft"}) with a mean of \code{hp.tau.mean}, 
a standard deviation of \code{hp.tau.sigma} and \code{hp.tau.df} degrees of freedom. This distribution is again 
restricted to the range \code{hp.tau.min} to \code{hp.tau.max}.
}
}
\note{
The width of calculated confidence, credibility and prediction intervals can be specified 
using \code{level} in the \code{pars} argument (defaults to 0.95).
}
\examples{
######### Validation of prediction models with a binary outcome #########
data(EuroSCORE)

# Meta-analysis of the c-statistic (random effects)
fit <- valmeta(cstat=c.index, cstat.se=se.c.index, cstat.cilb=c.index.95CIl, 
               cstat.ciub=c.index.95CIu, cstat.cilv=0.95, N=n, O=n.events, 
               slab=Study, data=EuroSCORE)
plot(fit)

# Nearly identical results when we need to estimate the SE
valmeta(cstat=c.index,  N=n, O=n.events, slab=Study, data=EuroSCORE)

# Two-stage meta-analysis of the total O:E ratio (random effects)
valmeta(measure="OE", O=n.events, E=e.events, N=n, data=EuroSCORE)    
valmeta(measure="OE", O=n.events, E=e.events, data=EuroSCORE)       
valmeta(measure="OE", Po=Po, Pe=Pe, N=n, data=EuroSCORE)

\dontrun{
# One-stage meta-analysis of the total O:E ratio (random effects)
valmeta(measure="OE", O=n.events, E=e.events, data=EuroSCORE, method="ML", 
        pars=list(model.oe="poisson/log"))

# Bayesian random effects meta-analysis of the c-statistic
fit2 <- valmeta(cstat=c.index, cstat.se=se.c.index, cstat.cilb=c.index.95CIl,
                cstat.ciub=c.index.95CIu, cstat.cilb=0.95, N=n, O=n.events, 
                data=EuroSCORE, method="BAYES", slab=Study)

# Bayesian one-stage random effects meta-analysis of the total O:E ratio
# Consider that some (but not all) studies do not provide information on N
# A Poisson distribution will be used for studies 1, 2, 5, 10 and 20
# A Binomial distribution will be used for the remaining studies
EuroSCORE.new <- EuroSCORE
EuroSCORE.new$n[c(1, 2, 5, 10, 20)] <-  NA
pars <- list(hp.tau.dist="dhalft",   # Prior for the between-study standard deviation
             hp.tau.sigma=1.5,       # Standard deviation for 'hp.tau.dist'
             hp.tau.df=3,            # Degrees of freedom for 'hp.tau.dist'
             hp.tau.max=10)          # Maximum value for the between-study standard deviation
fit3 <- valmeta(measure="OE", O=n.events, E=e.events, N=n, data=EuroSCORE.new,
        method="BAYES", slab=Study, pars=pars, ret.fit = T)
plot(fit3)
print(fit3$fit$model) # Inspect the JAGS model
print(fit3$fit$data)  # Inspect the JAGS data
} 

######### Validation of prediction models with a time-to-event outcome #########
data(Framingham)

# Meta-analysis of total O:E ratio after 10 years of follow-up
valmeta(measure="OE", Po=Po, Pe=Pe, N=n, data=Framingham)

}
\references{
Debray TPA, Damen JAAG, Snell KIE, Ensor J, Hooft L, Reitsma JB, et al. A guide to systematic review and meta-analysis 
of prediction model performance. \emph{BMJ}. 2017;356:i6460.

Debray TPA, Damen JAAG, Riley R, Snell KIE, Reitsma JB, Hooft L, et al. A framework for meta-analysis of prediction model studies with binary and time-to-event outcomes. \emph{Stat Methods Med Res}. 2019 Sep;28(9):2768--86. 

Steyerberg EW, Nieboer D, Debray TPA, van Houwelingen HC. Assessment of heterogeneity in an individual participant
data meta-analysis of prediction models: An overview and illustration. \emph{Stat Med}. 2019; In press.

Viechtbauer W. Conducting Meta-Analyses in R with the metafor Package. \emph{Journal of Statistical Software}. 
2010; 36(3). Available from: \url{https://www.jstatsoft.org/v36/i03/}
}
\seealso{
\code{\link{ccalc}} to calculate concordance statistics and corresponding standard errors, \code{\link{oecalc}} to 
calculate the total O:E ratio and corresponding standard errors, 
\code{\link{plot.valmeta}} to generate forest plots
}
\keyword{calibration}
\keyword{discrimination}
\keyword{meta-analysis}
