% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxtab6.R
\docType{data}
\name{taxtab6}
\alias{taxtab6}
\title{Taxonomic relative abundance data.}
\format{A data frame with 322 row (samples) and 803 variables (including mapping varilable and bacterial taxonomies from phylum to genus level).}
\source{
\href{https://gordonlab.wustl.edu/Subramanian_6_14/Nature_2014_Processed_16S_rRNA_datasets.html}{Gordon Lab}
}
\usage{
data(taxtab6)
}
\description{
Monthly longitudinal relative abundance data from phylum to genus level of
50 infants from birth to 2 year of life.
Mapping file is merged to the data for ready use.
}
\examples{
#Load summary tables of bacterial taxa relative abundance from Bangladesh data
data(taxtab6)
tl<-colnames(taxtab6)[grep("k__bacteria.p__fusobacteria",colnames(taxtab6))]
taxacom.ex<-taxa.compare(taxtab=taxtab6[,c("personid","x.sampleid","bf","age.sample",tl)],
propmed.rel="gamlss",comvar="bf",adjustvar="age.sample",
longitudinal="yes",p.adjust.method="fdr")
}
\references{
Subramanian et al. Nature. 2014 Jun 19; 510(7505): 417–421.
(\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4189846/}{PubMed})
}
\keyword{datasets}
