% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend_ae_specific.R
\name{extend_ae_specific_duration}
\alias{extend_ae_specific_duration}
\title{Add average duration information for AE specific analysis}
\usage{
extend_ae_specific_duration(outdata, duration_var, duration_unit = "Day")
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=prepare_ae_specific]{prepare_ae_specific()}}.}

\item{duration_var}{A character value of variable name for adverse event duration.}

\item{duration_unit}{A character value of adverse event duration unit.}
}
\value{
A list of analysis raw datasets.
}
\description{
Add average duration information for AE specific analysis
}
\examples{
meta <- meta_ae_example()
tbl <- prepare_ae_specific(meta,
  population = "apat",
  observation = "wk12",
  parameter = "rel"
) |>
  extend_ae_specific_duration(duration_var = "ADURN") |>
  format_ae_specific(display = c("n", "prop", "dur"))
head(tbl$tbl)
}
