% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_ae_specific.R
\name{prepare_ae_specific}
\alias{prepare_ae_specific}
\title{Prepare datasets for AE specific analysis}
\usage{
prepare_ae_specific(
  meta,
  population,
  observation,
  parameter,
  components = c("soc", "par"),
  reference_group = NULL
)
}
\arguments{
\item{meta}{A metadata object created by metalite.}

\item{population}{A character value of population term name.
The term name is used as key to link information.}

\item{observation}{A character value of observation term name.
The term name is used as key to link information.}

\item{parameter}{A character value of parameter term name.
The term name is used as key to link information.}

\item{components}{A character vector of components name.}

\item{reference_group}{An integer to indicate reference group.
Default is 2 if there are 2 groups, otherwise, the default is 1.}
}
\value{
A list of analysis raw datasets.
}
\description{
Prepare datasets for AE specific analysis
}
\examples{
meta <- meta_ae_example()
str(prepare_ae_specific(meta, "apat", "wk12", "rel"))

# Allow to extract each components
prepare_ae_specific(meta, "apat", "wk12", "rel", components = NULL)$data
prepare_ae_specific(meta, "apat", "wk12", "rel", components = "soc")$data
prepare_ae_specific(meta, "apat", "wk12", "rel", components = "par")$data
}
