% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_documentation.R
\docType{data}
\name{bryophytes_ex_data}
\alias{bryophytes_ex_data}
\title{Example dataset of bryophytes}
\format{An object of type \code{\link{taxmap}}}
\usage{
bryophytes_ex_data
}
\description{
A dataset containing information from 171 bryophytes family names scraped from \url{http://www.theplantlist.org/1.1/browse/B/}:
}
\examples{
\dontrun{

library(XML)
taxon_names <- XML::htmlTreeParse("http://www.theplantlist.org/1.1/browse/B/") \%>\% 
xmlRoot() \%>\%
  getNodeSet("//ul[@id='nametree']/li/a/i") \%>\%
  sapply(xmlValue)
  
bryophytes_ex_data <- extract_taxonomy(taxon_names, key = "name", database = "itis")
}

}
\keyword{datasets}

