% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabin.R
\name{metabin}
\alias{metabin}
\title{Meta-analysis of binary outcome data}
\usage{
metabin(
  event.e,
  n.e,
  event.c,
  n.c,
  studlab,
  data = NULL,
  subset = NULL,
  exclude = NULL,
  method = ifelse(tau.common, "Inverse", gs("method")),
  sm = ifelse(!is.na(charmatch(tolower(method), c("peto", "glmm", "ssw"), nomatch =
    NA)), "OR", gs("smbin")),
  incr = gs("incr"),
  allincr = gs("allincr"),
  addincr = gs("addincr"),
  allstudies = gs("allstudies"),
  MH.exact = gs("MH.exact"),
  RR.Cochrane = gs("RR.Cochrane"),
  Q.Cochrane = gs("Q.Cochrane") & method == "MH" & method.tau == "DL",
  model.glmm = "UM.FS",
  level = gs("level"),
  level.comb = gs("level.comb"),
  comb.fixed = gs("comb.fixed"),
  comb.random = gs("comb.random"),
  overall = comb.fixed | comb.random,
  overall.hetstat = comb.fixed | comb.random,
  hakn = gs("hakn"),
  adhoc.hakn = gs("adhoc.hakn"),
  method.tau = ifelse(!is.na(charmatch(tolower(method), "glmm", nomatch = NA)), "ML",
    gs("method.tau")),
  method.tau.ci = gs("method.tau.ci"),
  tau.preset = NULL,
  TE.tau = NULL,
  tau.common = gs("tau.common"),
  prediction = gs("prediction"),
  level.predict = gs("level.predict"),
  method.bias = ifelse(sm == "OR", "Harbord", ifelse(sm == "DOR", "Deeks",
    gs("method.bias"))),
  backtransf = gs("backtransf"),
  pscale = 1,
  text.fixed = gs("text.fixed"),
  text.random = gs("text.random"),
  text.predict = gs("text.predict"),
  text.w.fixed = gs("text.w.fixed"),
  text.w.random = gs("text.w.random"),
  title = gs("title"),
  complab = gs("complab"),
  outclab = "",
  label.e = gs("label.e"),
  label.c = gs("label.c"),
  label.left = gs("label.left"),
  label.right = gs("label.right"),
  byvar,
  bylab,
  print.byvar = gs("print.byvar"),
  byseparator = gs("byseparator"),
  print.CMH = gs("print.CMH"),
  keepdata = gs("keepdata"),
  warn = gs("warn"),
  control = NULL,
  ...
)
}
\arguments{
\item{event.e}{Number of events in experimental group or true
positives in diagnostic study.}

\item{n.e}{Number of observations in experimental group or number
of ill participants in diagnostic study.}

\item{event.c}{Number of events in control group or false positives
in diagnostic study.}

\item{n.c}{Number of observations in control group or number of
healthy participants in diagnostic study.}

\item{studlab}{An optional vector with study labels.}

\item{data}{An optional data frame containing the study
information, i.e., event.e, n.e, event.c, and n.c.}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots.}

\item{method}{A character string indicating which method is to be
used for pooling of studies. One of \code{"Inverse"},
\code{"MH"}, \code{"Peto"}, \code{"GLMM"}, or \code{"SSW"}, can
be abbreviated.}

\item{sm}{A character string indicating which summary measure
(\code{"RR"}, \code{"OR"}, \code{"RD"}, \code{"ASD"}, or
\code{"DOR"}) is to be used for pooling of studies, see Details.}

\item{incr}{Could be either a numerical value which is added to
each cell frequency for studies with a zero cell count or the
character string \code{"TACC"} which stands for treatment arm
continuity correction, see Details.}

\item{allincr}{A logical indicating if \code{incr} is added to each
cell frequency of all studies if at least one study has a zero
cell count. If FALSE (default), \code{incr} is added only to each
cell frequency of studies with a zero cell count.}

\item{addincr}{A logical indicating if \code{incr} is added to each
cell frequency of all studies irrespective of zero cell counts.}

\item{allstudies}{A logical indicating if studies with zero or all
events in both groups are to be included in the meta-analysis
(applies only if \code{sm} is equal to \code{"RR"}, \code{"OR"},
or \code{"DOR"}).}

\item{MH.exact}{A logical indicating if \code{incr} is not to be
added to all cell frequencies for studies with a zero cell count
to calculate the pooled estimate based on the Mantel-Haenszel
method.}

\item{RR.Cochrane}{A logical indicating if 2*\code{incr} instead of
1*\code{incr} is to be added to \code{n.e} and \code{n.c} in the
calculation of the risk ratio (i.e., \code{sm="RR"}) for studies
with a zero cell. This is used in RevMan 5, the program for
preparing and maintaining Cochrane reviews.}

\item{Q.Cochrane}{A logical indicating if the Mantel-Haenszel
estimate is used in the calculation of the heterogeneity
statistic Q which is implemented in RevMan 5, the program for
preparing and maintaining Cochrane reviews.}

\item{model.glmm}{A character string indicating which GLMM should
be used.  One of \code{"UM.FS"}, \code{"UM.RS"}, \code{"CM.EL"},
and \code{"CM.AL"}, see Details.}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{level.comb}{The level used to calculate confidence intervals
for pooled estimates.}

\item{comb.fixed}{A logical indicating whether a fixed effect
meta-analysis should be conducted.}

\item{comb.random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{hakn}{A logical indicating whether the method by Hartung and
Knapp should be used to adjust test statistics and confidence
intervals.}

\item{adhoc.hakn}{A character string indicating whether an \emph{ad
hoc} variance correction should be applied in the case of an
arbitrarily small Hartung-Knapp variance estimate, see Details.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau}. Either \code{"DL"}, \code{"PM"},
\code{"REML"}, \code{"ML"}, \code{"HS"}, \code{"SJ"},
\code{"HE"}, or \code{"EB"}, can be abbreviated.}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau}. Either \code{"QP"}, \code{"BJ"}, or \code{"J"}, or
\code{""}, can be abbreviated.}

\item{tau.preset}{Prespecified value for the square root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall treatment effect used to estimate the
between-study variance \eqn{\tau^2}.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{method.bias}{A character string indicating which test for
funnel plot asymmetry is to be used. Either \code{"Begg"},
\code{"Egger"}, \code{"Thompson"}, \code{"Schwarzer"},
\code{"Harbord"}, \code{"Peters"}, or \code{"Deeks"}, can be
abbreviated. See function \code{\link{metabias}.}}

\item{backtransf}{A logical indicating whether results for odds
ratio (\code{sm="OR"}), risk ratio (\code{sm="RR"}), or
diagnostic odds ratio (\code{sm="DOR"}) should be back
transformed in printouts and plots. If TRUE (default), results
will be presented as odds ratios and risk ratios; otherwise log
odds ratios and log risk ratios will be shown.}

\item{pscale}{A numeric defining a scaling factor for printing of
risk differences.}

\item{text.fixed}{A character string used in printouts and forest
plot to label the pooled fixed effect estimate.}

\item{text.random}{A character string used in printouts and forest
plot to label the pooled random effects estimate.}

\item{text.predict}{A character string used in printouts and forest
plot to label the prediction interval.}

\item{text.w.fixed}{A character string used to label weights of
fixed effect model.}

\item{text.w.random}{A character string used to label weights of
random effects model.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{label.e}{Label for experimental group.}

\item{label.c}{Label for control group.}

\item{label.left}{Graph label on left side of forest plot.}

\item{label.right}{Graph label on right side of forest plot.}

\item{byvar}{An optional vector containing grouping information
(must be of same length as \code{event.e}).}

\item{bylab}{A character string with a label for the grouping
variable.}

\item{print.byvar}{A logical indicating whether the name of the
grouping variable should be printed in front of the group labels.}

\item{byseparator}{A character string defining the separator
between label and levels of grouping variable.}

\item{print.CMH}{A logical indicating whether result of the
Cochran-Mantel-Haenszel test for overall effect should be
printed.}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if \code{incr} is added to studies with zero cell
frequencies).}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.uni}} or
\code{\link[metafor]{rma.glmm}}, respectively.}

\item{\dots}{Additional arguments passed on to
\code{\link[metafor]{rma.glmm}} function.}
}
\value{
An object of class \code{c("metabin", "meta")} with corresponding
\code{print}, \code{summary}, and \code{forest} functions. The
object is a list containing the following components:

\item{event.e, n.e, event.c, n.c, studlab, exclude,}{As defined
  above.}
\item{sm, method, incr, allincr, addincr,}{As defined above.}
\item{allstudies, MH.exact, RR.Cochrane, Q.Cochrane, model.glmm,}{As
  defined above.}
\item{warn, level, level.comb, comb.fixed, comb.random,}{As defined
  above.}
\item{overall, overall.hetstat,}{As defined above.}
\item{hakn, adhoc.hakn, method.tau, method.tau.ci,}{As defined above.}
\item{tau.preset, TE.tau, method.bias,}{As defined above.}
\item{tau.common, title, complab, outclab,}{As defined above.}
\item{label.e, label.c, label.left, label.right,}{As defined
  above.}
\item{byvar, bylab, print.byvar, byseparator}{As defined above.}
\item{TE, seTE}{Estimated treatment effect and standard error of
  individual studies.}
\item{lower, upper}{Lower and upper confidence interval limits for
  individual studies.}
\item{zval, pval}{z-value and p-value for test of treatment effect
  for individual studies.}
\item{w.fixed, w.random}{Weight of individual studies (in fixed and
  random effects model).}
\item{TE.fixed, seTE.fixed}{Estimated overall treatment effect,
  e.g., log risk ratio or risk difference, and standard error
  (fixed effect model).}
\item{lower.fixed, upper.fixed}{Lower and upper confidence interval
  limits (fixed effect model).}
\item{statistic.fixed, pval.fixed}{z-value and p-value for test of
  overall treatment effect (fixed effect model).}
\item{TE.random, seTE.random}{Estimated overall treatment effect,
  e.g., log risk ratio or risk difference, and standard error
  (random effects model).}
\item{lower.random, upper.random}{Lower and upper confidence
  interval limits (random effects model).}
\item{statistic.random, pval.random}{z-value or t-value and
  corresponding p-value for test of overall treatment effect
  (random effects model).}  \item{prediction, level.predict}{As
  defined above.}
\item{seTE.predict}{Standard error utilised for prediction
  interval.}
\item{lower.predict, upper.predict}{Lower and upper limits of
  prediction interval.}
\item{k}{Number of studies combined in meta-analysis.}
\item{Q}{Heterogeneity statistic Q.}
\item{df.Q}{Degrees of freedom for heterogeneity statistic.}
\item{pval.Q}{P-value of heterogeneity test.}
\item{Q.LRT}{Heterogeneity statistic for likelihood-ratio test
  (only if \code{method = "GLMM"}).}
\item{df.Q.LRT}{Degrees of freedom for likelihood-ratio test}
\item{pval.Q.LRT}{P-value of likelihood-ratio test.}
\item{tau2}{Between-study variance \eqn{\tau^2}.}
\item{se.tau2}{Standard error of \eqn{\tau^2}.}
\item{lower.tau2, upper.tau2}{Lower and upper limit of confidence
  interval for \eqn{\tau^2}.}
\item{tau}{Square-root of between-study variance \eqn{\tau}.}
\item{lower.tau, upper.tau}{Lower and upper limit of confidence
  interval for \eqn{\tau}.}
\item{H}{Heterogeneity statistic H.}
\item{lower.H, upper.H}{Lower and upper confidence limit for
 heterogeneity statistic H.}
\item{I2}{Heterogeneity statistic I\eqn{^2}.}
\item{lower.I2, upper.I2}{Lower and upper confidence limit for
  heterogeneity statistic I\eqn{^2}.}
\item{Rb}{Heterogeneity statistic R\eqn{_b}.}
\item{lower.Rb, upper.Rb}{Lower and upper confidence limit for
  heterogeneity statistic R\eqn{_b}.}
\item{Q.CMH}{Cochran-Mantel-Haenszel test statistic for overall
  effect.}
\item{df.Q.CMH}{Degrees of freedom for Cochran-Mantel-Haenszel test
  statistic.}
\item{pval.Q.CMH}{P-value of Cochran-Mantel-Haenszel test.}
\item{incr.e, incr.c}{Increment added to cells in the experimental
  and control group, respectively.}
\item{sparse}{Logical flag indicating if any study included in
  meta-analysis has any zero cell frequencies.}
\item{doublezeros}{Logical flag indicating if any study has zero
  cell frequencies in both treatment groups.}
\item{df.hakn}{Degrees of freedom for test of treatment effect for
  Hartung-Knapp method (only if \code{hakn = TRUE}).}
\item{k.MH}{Number of studies combined in meta-analysis using
  Mantel-Haenszel method.}
\item{bylevs}{Levels of grouping variable - if \code{byvar} is not
  missing.}
\item{TE.fixed.w, seTE.fixed.w}{Estimated treatment effect and
  standard error in subgroups (fixed effect model) - if
  \code{byvar} is not missing.}  \item{lower.fixed.w,
  upper.fixed.w}{Lower and upper confidence interval limits in
  subgroups (fixed effect model) - if \code{byvar} is not missing.}

\item{statistic.fixed.w, pval.fixed.w}{z-value and p-value for test
  of treatment effect in subgroups (fixed effect model) - if
  \code{byvar} is not missing.}  \item{TE.random.w,
  seTE.random.w}{Estimated treatment effect and standard error in
  subgroups (random effects model) - if \code{byvar} is not
  missing.}
\item{lower.random.w, upper.random.w}{Lower and upper confidence
  interval limits in subgroups (random effects model) - if
  \code{byvar} is not missing.}
\item{statistic.random.w, pval.random.w}{z-value or t-value and
  corresponding p-value for test of treatment effect in subgroups
  (random effects model) - if \code{byvar} is not missing.}
\item{w.fixed.w, w.random.w}{Weight of subgroups (in fixed and
  random effects model) - if \code{byvar} is not missing.}
  \item{df.hakn.w}{Degrees of freedom for test of treatment effect
  for Hartung-Knapp method in subgroups - if \code{byvar} is not
  missing and \code{hakn = TRUE}.}  \item{event.e.w}{Number of
  events in experimental group in subgroups - if \code{byvar} is
  not missing.}  \item{n.e.w}{Number of observations in
  experimental group in subgroups - if \code{byvar} is not
  missing.}  \item{event.c.w}{Number of events in control group in
  subgroups - if \code{byvar} is not missing.}  \item{n.c.w}{Number
  of observations in control group in subgroups - if \code{byvar}
  is not missing.}  \item{k.w}{Number of studies combined within
  subgroups - if \code{byvar} is not missing.}
  \item{k.all.w}{Number of all studies in subgroups - if
  \code{byvar} is not missing.}  \item{Q.w.fixed}{Overall within
  subgroups heterogeneity statistic Q (based on fixed effect model)
  - if \code{byvar} is not missing.}  \item{Q.w.random}{Overall
  within subgroups heterogeneity statistic Q (based on random
  effects model) - if \code{byvar} is not missing (only calculated
  if argument \code{tau.common} is TRUE).}  \item{df.Q.w}{Degrees
  of freedom for test of overall within subgroups heterogeneity -
  if \code{byvar} is not missing.}  \item{pval.Q.w.fixed}{P-value
  of within subgroups heterogeneity statistic Q (based on fixed
  effect model) - if \code{byvar} is not missing.}
  \item{pval.Q.w.random}{P-value of within subgroups heterogeneity
  statistic Q (based on random effects model) - if \code{byvar} is
  not missing.}  \item{Q.b.fixed}{Overall between subgroups
  heterogeneity statistic Q (based on fixed effect model) - if
  \code{byvar} is not missing.}  \item{Q.b.random}{Overall between
  subgroups heterogeneity statistic Q (based on random effects
  model) - if \code{byvar} is not missing.}  \item{df.Q.b}{Degrees
  of freedom for test of overall between subgroups heterogeneity -
  if \code{byvar} is not missing.}  \item{pval.Q.b.fixed}{P-value
  of between subgroups heterogeneity statistic Q (based on fixed
  effect model) - if \code{byvar} is not missing.}
  \item{pval.Q.b.random}{P-value of between subgroups heterogeneity
  statistic Q (based on random effects model) - if \code{byvar} is
  not missing.}  \item{tau.w}{Square-root of between-study variance
  within subgroups - if \code{byvar} is not missing.}
  \item{H.w}{Heterogeneity statistic H within subgroups - if
  \code{byvar} is not missing.}  \item{lower.H.w, upper.H.w}{Lower
  and upper confidence limit for heterogeneity statistic H within
  subgroups - if \code{byvar} is not missing.}
  \item{I2.w}{Heterogeneity statistic I\eqn{^2} within subgroups -
  if \code{byvar} is not missing.}  \item{lower.I2.w,
  upper.I2.w}{Lower and upper confidence limit for heterogeneity
  statistic I\eqn{^2} within subgroups - if \code{byvar} is not
  missing.}  \item{keepdata}{As defined above.}
  \item{data}{Original data (set) used in function call (if
  \code{keepdata = TRUE}).}  \item{subset}{Information on subset of
  original data used in meta-analysis (if \code{keepdata = TRUE}).}
  \item{.glmm.fixed}{GLMM object generated by call of
  \code{\link[metafor]{rma.glmm}} function (fixed effect model).}
  \item{.glmm.random}{GLMM object generated by call of
  \code{\link[metafor]{rma.glmm}} function (random effects model).}
  \item{call}{Function call.}  \item{version}{Version of R package
  \bold{meta} used to create object.}
  \item{version.metafor}{Version of R package \bold{metafor} used
  for GLMMs.}
}
\description{
Calculation of fixed effect and random effects estimates (risk
ratio, odds ratio, risk difference, arcsine difference, or
diagnostic odds ratio) for meta-analyses with binary outcome
data. Mantel-Haenszel, inverse variance, Peto method, generalised
linear mixed model (GLMM), and sample size method are available for
pooling. For GLMMs, the \code{\link[metafor]{rma.glmm}} function
from R package \bold{metafor} (Viechtbauer, 2010) is called
internally.
}
\details{
Calculation of fixed and random effects estimates for meta-analyses
with binary outcome data.

The following measures of treatment effect are available (Rücker et
al., 2009):

\itemize{
\item Risk ratio (\code{sm = "RR"})
\item Odds ratio (\code{sm = "OR"})
\item Risk difference (\code{sm = "RD"})
\item Arcsine difference (\code{sm = "ASD"})
\item Diagnostic Odds ratio (\code{sm = "DOR"})
}

Note, mathematically, odds ratios and diagnostic odds ratios are
identical, however, the labels in printouts and figures differ.

Default settings are utilised for several arguments (assignments
using \code{\link{gs}} function). These defaults can be changed for
the current R session using the \code{\link{settings.meta}}
function.

Furthermore, R function \code{\link{update.meta}} can be used to
rerun a meta-analysis with different settings.

\subsection{Meta-analysis method}{

By default, both fixed effect and random effects models are
considered (see arguments \code{comb.fixed} and
\code{comb.random}). If \code{method} is \code{"MH"} (default), the
Mantel-Haenszel method (Greenland & Robins, 1985; Robins et al.,
1986) is used to calculate the fixed effect estimate; if
\code{method} is \code{"Inverse"}, inverse variance weighting is
used for pooling (Fleiss, 1993); if \code{method} is \code{"Peto"},
the Peto method is used for pooling (Yussuf et al., 1985); if
\code{method} is \code{"SSW"}, the sample size method is used for
pooling (Bakbergenuly et al., 2020).

While the Mantel-Haenszel and Peto method are defined under the
fixed effect model, random effects variants based on these methods
are also implemented in \code{metabin}. Following RevMan 5, the
Mantel-Haenszel estimator is used in the calculation of the
between-study heterogeneity statistic Q which is used in the
DerSimonian-Laird estimator. Accordlingly, the results for the
random effects meta-analysis using the Mantel-Haenszel or inverse
variance method are typically very similar. For the Peto method,
Peto's log odds ratio, i.e. \code{(O-E) / V} and its standard error
\code{sqrt(1 / V)} with \code{O-E} and \code{V} denoting
"Observed minus Expected" and its variance, are utilised in the
random effects model. Accordingly, results of a random effects
model using \code{sm = "Peto"} can be different to results from a
random effects model using \code{sm = "MH"} or \code{sm =
"Inverse"}.

A distinctive and frequently overlooked advantage of binary
endpoints is that individual patient data (IPD) can be extracted
from a two-by-two table.  Accordingly, statistical methods for IPD,
i.e., logistic regression and generalised linear mixed models, can
be utilised in a meta-analysis of binary outcomes (Stijnen et al.,
2010; Simmonds et al., 2016). These methods are available (argument
\code{method = "GLMM"}) for the odds ratio as summary measure by
calling the \code{\link[metafor]{rma.glmm}} function from R package
\bold{metafor} internally.

Four different GLMMs are available for
meta-analysis with binary outcomes using argument \code{model.glmm}
(which corresponds to argument \code{model} in the
\code{\link[metafor]{rma.glmm}} function):
\tabular{cl}{
1. \tab Logistic regression model with fixed study effects
 (default) \cr
 \tab (\code{model.glmm = "UM.FS"}, i.e., \bold{U}nconditional
 \bold{M}odel - \bold{F}ixed \bold{S}tudy effects) \cr
2. \tab Mixed-effects logistic regression model with random study
 effects \cr
 \tab (\code{model.glmm = "UM.RS"}, i.e., \bold{U}nconditional
 \bold{M}odel - \bold{R}andom \bold{S}tudy effects) \cr
3. \tab Generalised linear mixed model (conditional
 Hypergeometric-Normal) \cr
 \tab (\code{model.glmm = "CM.EL"}, i.e., \bold{C}onditional
 \bold{M}odel - \bold{E}xact \bold{L}ikelihood) \cr
4. \tab Generalised linear mixed model (conditional
  Binomial-Normal) \cr
 \tab (\code{model.glmm = "CM.AL"}, i.e., \bold{C}onditional
  \bold{M}odel - \bold{A}pproximate \bold{L}ikelihood)
}

Details on these four GLMMs as well as additional arguments which
can be provided using argument '\code{\dots}' in \code{metabin}
are described in \code{\link[metafor]{rma.glmm}} where you can also
find information on the iterative algorithms used for estimation.
Note, regardless of which value is used for argument
\code{model.glmm}, results for two different GLMMs are calculated:
fixed effect model (with fixed treatment effect) and random effects
model (with random treatment effects).
}

\subsection{Continuity correction}{

For studies with a zero cell count, by default, 0.5 is added to all
cell frequencies of these studies; if \code{incr} is \code{"TACC"}
a treatment arm continuity correction is used instead (Sweeting et
al., 2004; Diamond et al., 2007). For odds ratio and risk ratio,
treatment estimates and standard errors are only calculated for
studies with zero or all events in both groups if \code{allstudies}
is \code{TRUE}. This continuity correction is used both to
calculate individual study results with confidence limits and to
conduct meta-analysis based on the inverse variance method. For
Peto method and GLMMs no continuity correction is used. For the
Mantel-Haenszel method, by default (if \code{MH.exact} is FALSE),
\code{incr} is added to all cell frequencies of a study with a zero
cell count in the calculation of the pooled risk ratio or odds
ratio as well as the estimation of the variance of the pooled risk
difference, risk ratio or odds ratio. This approach is also used in
other software, e.g. RevMan 5 and the Stata procedure
metan. According to Fleiss (in Cooper & Hedges, 1994), there is no
need to add 0.5 to a cell frequency of zero to calculate the
Mantel-Haenszel estimate and he advocates the exact method
(\code{MH.exact} = TRUE). Note, estimates based on exact
Mantel-Haenszel method or GLMM are not defined if the number of
events is zero in all studies either in the experimental or control
group.
}

\subsection{Estimation of between-study variance}{

The following methods to estimate the between-study variance
\eqn{\tau^2} are available for the inverse variance method:
\itemize{
\item DerSimonian-Laird estimator (\code{method.tau = "DL"})
\item Paule-Mandel estimator (\code{method.tau = "PM"})
\item Restricted maximum-likelihood estimator (\code{method.tau =
  "REML"})
\item Maximum-likelihood estimator (\code{method.tau = "ML"})
\item Hunter-Schmidt estimator (\code{method.tau = "HS"})
\item Sidik-Jonkman estimator (\code{method.tau = "SJ"})
\item Hedges estimator (\code{method.tau = "HE"})
\item Empirical Bayes estimator (\code{method.tau = "EB"})
}
See \code{\link{metagen}} for more information on these
estimators. Note, the maximum-likelihood method is utilized for
GLMMs.
}

\subsection{Confidence interval for the between-study variance}{

The following methods to calculate a confidence interval for
\eqn{\tau^2} and \eqn{\tau} are available.
\tabular{ll}{
\bold{Argument}\tab \bold{Method} \cr 
\code{method.tau.ci = "J"}\tab Method by Jackson \cr
\code{method.tau.ci = "BJ"}\tab Method by Biggerstaff and Jackson \cr
\code{method.tau.ci = "QP"}\tab Q-Profile method
}
See \code{\link{metagen}} for more information on these
methods. For GLMMs, no confidence intervals for \eqn{\tau^2} and
\eqn{\tau} are calculated. Likewise, no confidence intervals for
\eqn{\tau^2} and \eqn{\tau} are calculated if \code{method.tau.ci =
""}. 
}

\subsection{Hartung-Knapp method}{

Hartung and Knapp (2001a,b) proposed an alternative method for
random effects meta-analysis based on a refined variance estimator
for the treatment estimate. Simulation studies (Hartung and Knapp,
2001a,b; IntHout et al., 2014; Langan et al., 2019) show improved
coverage probabilities compared to the classic random effects
method.

In rare settings with very homogeneous treatment estimates, the
Hartung-Knapp variance estimate can be arbitrarily small resulting
in a very narrow confidence interval (Knapp and Hartung, 2003;
Wiksten et al., 2016). In such cases, an
\emph{ad hoc} variance correction has been proposed by utilising
the variance estimate from the classic random effects model with
the HK method (Knapp and Hartung, 2003; IQWiQ, 2020). An
alternative approach is to use the wider confidence interval of
classic fixed or random effects meta-analysis and the HK method
(Wiksten et al., 2016; Jackson et al., 2017).

Argument \code{adhoc.hakn} can be used to choose the \emph{ad hoc}
method:
\tabular{ll}{
\bold{Argument}\tab \bold{\emph{Ad hoc} method} \cr
\code{adhoc.hakn = ""}\tab not used \cr
\code{adhoc.hakn = "se"}\tab use variance correction if HK standard
 error is smaller \cr
 \tab than standard error from classic random effects
 \cr
 \tab meta-analysis (Knapp and Hartung, 2003) \cr
\code{adhoc.hakn = "iqwig6"}\tab use variance correction if HK
 confidence interval \cr
 \tab is narrower than CI from classic random effects model \cr
 \tab with DerSimonian-Laird estimator (IQWiG, 2020) \cr
\code{adhoc.hakn = "ci"}\tab use wider confidence interval of
 classic random effects \cr
 \tab and HK meta-analysis \cr
 \tab (Hybrid method 2 in Jackson et al., 2017)
}
}

\subsection{Prediction interval}{

A prediction interval for the proportion in a new study (Higgins et
al., 2009) is calculated if arguments \code{prediction} and
\code{comb.random} are \code{TRUE}. Note, the definition of
prediction intervals varies in the literature. This function
implements equation (12) of Higgins et al., (2009) which proposed a
\emph{t} distribution with \emph{K-2} degrees of freedom where
\emph{K} corresponds to the number of studies in the meta-analysis.

For GLMMs, a method similar to Knapp and Hartung (2003) is
implemented, see description of argument \code{tdist} in
\code{\link[metafor]{rma.glmm}}.
}

\subsection{Subgroup analysis}{

Argument \code{byvar} can be used to conduct subgroup analysis for
a categorical covariate. The \code{\link{metareg}} function can be
used instead for more than one categorical covariate or continuous
covariates.
}

\subsection{Exclusion of studies from meta-analysis}{

Arguments \code{subset} and \code{exclude} can be used to exclude
studies from the meta-analysis. Studies are removed completely from
the meta-analysis using argument \code{subset}, while excluded
studies are shown in printouts and forest plots using argument
\code{exclude} (see Examples in \code{\link{metagen}}).
Meta-analysis results are the same for both arguments.
}

\subsection{Presentation of meta-analysis results}{

Internally, both fixed effect and random effects models are
calculated regardless of values choosen for arguments
\code{comb.fixed} and \code{comb.random}. Accordingly, the estimate
for the random effects model can be extracted from component
\code{TE.random} of an object of class \code{"meta"} even if
argument \code{comb.random = FALSE}. However, all functions in R
package \bold{meta} will adequately consider the values for
\code{comb.fixed} and \code{comb.random}. E.g. function
\code{\link{print.meta}} will not print results for the random
effects model if \code{comb.random = FALSE}.
}
}
\examples{
# Calculate odds ratio and confidence interval for a single study
#
metabin(10, 20, 15, 20, sm = "OR")

# Different results (due to handling of studies with double zeros)
#
metabin(0, 10, 0, 10, sm = "OR")
metabin(0, 10, 0, 10, sm = "OR", allstudies = TRUE)

# Use subset of Olkin (1995) to conduct meta-analysis based on
# inverse variance method (with risk ratio as summary measure)
#
data(Olkin1995)
m1 <- metabin(ev.exp, n.exp, ev.cont, n.cont,
              data = Olkin1995, subset = c(41, 47, 51, 59),
              method = "Inverse")
summary(m1)

# Use different subset of Olkin (1995)
#
m2 <- metabin(ev.exp, n.exp, ev.cont, n.cont,
              data = Olkin1995, subset = year < 1970,
              method = "Inverse", studlab = author)
summary(m2)
forest(m2)

# Meta-analysis with odds ratio as summary measure
#
m3 <- metabin(ev.exp, n.exp, ev.cont, n.cont,
              data = Olkin1995, subset = year < 1970,
              sm = "OR", method = "Inverse", studlab = author)
# Same meta-analysis result using 'update.meta' function
m3 <- update(m2, sm = "OR")
summary(m3)

# Meta-analysis based on Mantel-Haenszel method (with odds ratio as
# summary measure)
#
m4 <- update(m3, method = "MH")
summary(m4)

# Meta-analysis based on Peto method (only available for odds ratio
# as summary measure)
#
m5 <- update(m3, method = "Peto")
summary(m5)

\dontrun{
# Meta-analysis using generalised linear mixed models (only if R
# packages 'metafor' and 'lme4' are available)
#
if (suppressMessages(require(metafor, quietly = TRUE, warn = FALSE)) &
    require(lme4, quietly = TRUE)) {

# Logistic regression model with (k = 4) fixed study effects
# (default: model.glmm = "UM.FS")
#
m6 <- metabin(ev.exp, n.exp, ev.cont, n.cont,
              data = Olkin1995, subset = year < 1970,
              method = "GLMM")
# Same results:
m6 <- update(m2, method = "GLMM")
summary(m6)

# Mixed-effects logistic regression model with random study effects
# (warning message printed due to argument 'nAGQ')
#
m7 <- update(m6, model.glmm = "UM.RS")
#
# Use additional argument 'nAGQ' for internal call of 'rma.glmm'
# function
#
m7 <- update(m6, model.glmm = "UM.RS", nAGQ = 1)
summary(m7)

# Generalised linear mixed model (conditional
# Hypergeometric-Normal) (R package 'BiasedUrn' must be available)
#
if (require(BiasedUrn, quietly = TRUE)) {
 m8 <- update(m6, model.glmm = "CM.EL")
 summary(m8)
}

# Generalised linear mixed model (conditional Binomial-Normal)
#
m9 <- update(m6, model.glmm = "CM.AL")
summary(m9)

# Logistic regression model with (k = 70) fixed study effects
# (about 18 seconds with Intel Core i7-3667U, 2.0GHz)
#
m10 <- metabin(ev.exp, n.exp, ev.cont, n.cont,
               data = Olkin1995, method = "GLMM")
summary(m10)

# Mixed-effects logistic regression model with random study effects
# - about 50 seconds with Intel Core i7-3667U, 2.0GHz
# - several warning messages, e.g. "failure to converge, ..."
#
summary(update(m10, model.glmm = "UM.RS"))

# Conditional Hypergeometric-Normal GLMM
# - long computation time (about 12 minutes with Intel Core
#   i7-3667U, 2.0GHz)
# - estimation problems for this very large dataset:
#   * warning that Choleski factorization of Hessian failed
#   * confidence interval for treatment effect smaller in random
#     effects model compared to fixed effect model
#
if (require(BiasedUrn, quietly = TRUE)) {
 system.time(m11 <- update(m10, model.glmm = "CM.EL"))
 summary(m11)
}

# Generalised linear mixed model (conditional Binomial-Normal)
# (less than 1 second with Intel Core i7-3667U, 2.0GHz)
#
summary(update(m10, model.glmm = "CM.AL"))
}
}

}
\references{
Bakbergenuly I, Hoaglin DC, Kulinskaya E (2020):
Methods for estimating between-study variance and overall
effect in meta-analysis of odds-ratios.
\emph{Research Synthesis Methods},
DOI: 10.1002/jrsm.1404

Cooper H & Hedges LV (1994):
\emph{The Handbook of Research Synthesis}.
Newbury Park, CA: Russell Sage Foundation

Diamond GA, Bax L, Kaul S (2007):
Uncertain Effects of Rosiglitazone on the Risk for Myocardial
Infarction and Cardiovascular Death.
\emph{Annals of Internal Medicine},
\bold{147}, 578--81

DerSimonian R & Laird N (1986):
Meta-analysis in clinical trials.
\emph{Controlled Clinical Trials},
\bold{7}, 177--88

Fleiss JL (1993):
The statistical basis of meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{2}, 121--45

Greenland S & Robins JM (1985):
Estimation of a common effect parameter from sparse follow-up data.
\emph{Biometrics},
\bold{41}, 55--68

Hartung J & Knapp G (2001):
A refined method for the meta-analysis of controlled clinical
trials with binary outcome.
\emph{Statistics in Medicine},
\bold{20}, 3875--89

Higgins JPT, Thompson SG, Spiegelhalter DJ (2009):
A re-evaluation of random-effects meta-analysis.
\emph{Journal of the Royal Statistical Society: Series A},
\bold{172}, 137--59

IQWiG (2020):
General Methods: Version 6.0.
\url{https://www.iqwig.de/en/about-us/methods/methods-paper/}

Knapp G & Hartung J (2003):
Improved tests for a random effects meta-regression with a single
covariate.
\emph{Statistics in Medicine},
\bold{22}, 2693--710

\emph{Review Manager (RevMan)} [Computer program]. Version 5.4.
The Cochrane Collaboration, 2020

Paule RC & Mandel J (1982):
Consensus values and weighting factors.
\emph{Journal of Research of the National Bureau of Standards},
\bold{87}, 377--85

Pettigrew HM, Gart JJ, Thomas DG (1986):
The bias and higher cumulants of the logarithm of a binomial
variate.
\emph{Biometrika},
\bold{73}, 425--35

Robins J, Breslow N, Greenland S (1986):
Estimators of the Mantel-Haenszel Variance Consistent in Both
Sparse Data and Large-Strata Limiting Models.
\emph{Biometrics},
\bold{42}, 311--23

Rücker G, Schwarzer G, Carpenter J, Olkin I (2009):
Why add anything to nothing? The arcsine difference as a measure of
treatment effect in meta-analysis with zero cells.
\emph{Statistics in Medicine},
\bold{28}, 721--38

Simmonds MC, Higgins JP (2016):
A general framework for the use of logistic regression models in
meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{25}, 2858--77

StataCorp. 2011.
\emph{Stata Statistical Software: Release 12}.
College Station, TX: StataCorp LP.

Stijnen T, Hamza TH, Ozdemir P (2010):
Random effects meta-analysis of event outcome in the framework of
the generalized linear mixed model with applications in sparse
data.
\emph{Statistics in Medicine},
\bold{29}, 3046--67

Sweeting MJ, Sutton AJ, Lambert PC (2004):
What to add to nothing? Use and avoidance of continuity corrections
in meta-analysis of sparse data.
\emph{Statistics in Medicine},
\bold{23}, 1351--75

Viechtbauer W (2010):
Conducting meta-analyses in R with the metafor package.
\emph{Journal of Statistical Software},
\bold{36}, 1--48

Wiksten A, Rücker G, Schwarzer G (2016):
Hartung-Knapp method is not always conservative compared with
fixed-effect meta-analysis.
\emph{Statistics in Medicine},
\bold{35}, 2503--15

Yusuf S, Peto R, Lewis J, Collins R, Sleight P (1985):
Beta blockade during and after myocardial infarction: An overview
of the randomized trials.
\emph{Progress in Cardiovascular Diseases},
\bold{27}, 335--71
}
\seealso{
\code{\link{update.meta}}, \code{\link{forest}},
  \code{\link{funnel}}, \code{\link{metabias}},
  \code{\link{metacont}}, \code{\link{metagen}},
  \code{\link{metareg}}, \code{\link{print.meta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
