% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Impute2D.R
\name{Impute2D}
\alias{Impute2D}
\title{Impute missing values by linear or constant interpolation}
\usage{
Impute2D(formula, data = NULL, method = "interpolate")
}
\arguments{
\item{formula}{a formula indicating dependent and independent variables (see Details)}

\item{data}{optional data.frame with the data}

\item{method}{"interpolate" for interpolation, a numeric for constant imputation
or a function that takes a vector and returns a number (like \link{mean})}
}
\description{
Provides methods for (soft) imputation of missing values.
}
\details{
This is "soft" imputation because the imputed values are not supposed to be
representative of the missing data but just filling for algorithms that need
complete data (in particular, contouring). The method used if
\code{method = "interpolate"} is to do simple linear interpolation in both the x and y
direction and then average the result.

This is the imputation method used by \code{\link[=geom_contour_fill]{geom_contour_fill()}}.
}
