% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvertLongitude.R
\name{ConvertLongitude}
\alias{ConvertLongitude}
\title{Converts between longitude conventions}
\usage{
ConvertLongitude(lon, group = NULL, from = NULL)
}
\arguments{
\item{lon}{numeric vector of longitude}

\item{group}{optional vector of groups (the same length as longitude)
that will be split on the edges (see examples)}

\item{from}{optionally explicitly say from which convention to convert}
}
\value{
If \code{group} is missing, a numeric vector the same length of lon.
Else, a list with vectors \code{lon} and \code{group}.
}
\description{
Converts longitude from [0, 360) to [-180, 180) and vice versa.
}
\examples{
library(ggplot2)
library(data.table)
\dontshow{data.table::setDTthreads(1)}
data(geopotential)

ggplot(geopotential[date == date[1]], aes(lon, lat, z = gh)) +
    geom_contour(color = "black") +
    geom_contour(aes(x = ConvertLongitude(lon)))

map <- setDT(map_data("world"))
map[, c("lon", "group2") := ConvertLongitude(long, group, from = 180)]

ggplot(map, aes(lon, lat, group = group2)) +
    geom_path()

}
