% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set}
\alias{set}
\alias{md_intersect}
\alias{md_union}
\alias{md_multiset}
\title{Set operations for messy dates}
\usage{
md_intersect(...)

md_union(x, y)

md_multiset(x, y)
}
\arguments{
\item{x, y, ...}{Messy date or other class objects}
}
\value{
A vector of the same mode for \code{intersect},
or a common mode for union.
}
\description{
Performs intersection (\code{md_intersect()}) and union (\code{md_union()}) on,
inter alia, messy date class objects.
For a more typical 'join' that retains all elements, even if duplicated,
please use \code{md_multiset}.
}
\section{Functions}{
\itemize{
\item \code{md_intersect}: Find intersection of sets of messy dates

\item \code{md_union}: Find union of sets of messy dates

\item \code{md_multiset}: Join two sets of messy dates
}}

\examples{
md_intersect(as_messydate("2012-01-01..2012-01-20"),as_messydate("2012-01"))
md_union(as_messydate("2012-01-01..2012-01-20"),as_messydate("2012-01"))
md_multiset(as_messydate("2012-01-01..2012-01-20"),as_messydate("2012-01"))
}
