% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merlin_utils.R
\name{merlin_util_xzb_deriv}
\alias{merlin_util_xzb_deriv}
\title{merlin_util_xzb_deriv - returns the first derivative with respect to time of the
observation-level complex predictor}
\usage{
merlin_util_xzb_deriv(gml, t = NULL)
}
\arguments{
\item{gml}{merlin object - should not be edited}

\item{t}{specifies the variable which represents time}
}
\description{
Utility function to extract d/dt of the complex predictor evaluated at the current
parameter estimates for a particular model.
}
\examples{
library(merlin)
data(pbc.merlin, package = "merlin")

# Linear fixed-effects model
merlin(model = list(logb ~ year),
       family = "gaussian",
       data = pbc.merlin)
}
\references{
Crowther MJ. Extended multivariate generalised linear and non-linear mixed effects models. \url{https://arxiv.org/abs/1710.02223}

Crowther MJ. merlin - a unified framework for data analysis and methods development in Stata. \url{https://arxiv.org/abs/1806.01615}

Martin EC, Gasparini A, Crowther MJ. merlin - an R package for mixed effects regression of linear and non-linear models.
}
\author{
Michael J. Crowther
}
