% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_code_blocks.R
\name{clean_code_blocks}
\alias{clean_code_blocks}
\title{Clean code blocks returned by the agent}
\usage{
clean_code_blocks(response)
}
\arguments{
\item{response}{response received from the agent}
}
\value{
A string holding the response of the agent, cleaned from any unwanted characters.
}
\description{
This function cleans up the response
returned by the agent to ensure code blocks
can run. It ensures that characters such as
'R' and 'r' are cleaned from code blocks in the agents
response, so that the code blocks are able to be extracted by
the extractCode() function and ran as expected. It also cleans
the response from any install.package calls, and recorded output,
so that when code blocks are extracted, the code can run smoothly.
}
\examples{
{
response <- "To perform PCA, do the following: ```R prcomp(data)``` This funcion will perform PCA."
clean_code <- clean_code_blocks(response)
}
}
