summary.flu <-
function(object, ...){
  threshold<-as.data.frame(round(t(object$pre.post.intervals[1:2,3]),2))
  colnames(threshold)<-c("Pre","Post")
  rownames(threshold)<-"Threshold"
  values<-as.data.frame(round(object$epi.intervals[,4],2))
  colnames(values)<-"Threshold"
  rownames(values)<-paste(c("Medium","High","Very high")," (",round(object$epi.intervals[,1]*100,1),"%)",sep="")
	cat("Call:\n")
	print(object$call)
	cat("\nParameters:\n")
  cat("\t- General:\n")
  cat("\t\t+ Number of seasons restriction: ", if (object$param.max.seasons==-1) "Unrestricted (maximum)" else paste("Restricted to ",object$param.max.seasons,sep=""),"\n")
  cat("\t\t+ Number of seasons used: ", object$n.seasons,"\n")
  cat("\t\t+ Number of weeks: ", object$n.weeks,"\n")
 	cat("\t- Confidence intervals:\n")
 	cat("\t\t+ General: ", output.ci(object$param.type, object$param.level),"\n")
  cat("\t\t+ Curve: ", output.ci(object$param.type.curve,object$param.level.curve),"\n")
  cat("\t\t+ Thresholds: ", output.ci(object$param.type.threshold, object$param.level.threshold),"\n")
 	cat("\t- Epidemic timing calculation:\n")
  cat("\t\t+ Method: ", object$param.method,"\n")
  cat("\t\t+ Parameter: ", object$param.param,"\n")
 	cat("\t- Epidemic threshold calculation:\n")
  cat("\t\t+ Pre-epidemic values: ", if (object$param.n.max==-1) paste("Optimized: ",object$n.max,sep="") else object$n.max,"\n")
  cat("\t\t+ Tails of CI: ", object$param.tails,"\n")
 	cat("\t- Intensity thresholds calculation:\n")
  cat("\t\t+ Number of values: ", if (object$param.n.max==-1) paste("Optimized: ",object$n.max,sep="") else object$n.max,"\n")
  cat("\t\t+ Tails of CI: ", object$param.tails,"\n")
  cat("\t\t+ Levels of CI: ", paste(c("Medium","High","Very high"),": ",round(object$epi.intervals[,1]*100,1),"%",sep=""),"\n")
 	cat("\t- Bootstrap (if used):\n")
  cat("\t\t+ Technique: ", if (is.na(object$param.type.boot)) "-" else object$param.type.boot,"\n")
  cat("\t\t+ Bootstrap samples: ", if (is.na(object$param.iter.boot)) "-" else object$param.iter.boot,"\n")
	cat("\nEpidemic description:\n")
 	cat("\t- Typical influenza season lasts ",round(object$ci.length[1,2],2)," weeks. CL ",100*object$param.level,"% of\t[",round(object$ci.length[1,1],2),",",round(object$ci.length[1,3],2),"]\n")
 	cat("\t- This optimal ",object$mean.length," weeks influenza season includes the",round(object$ci.percent[2],2),"% of the total sum of rates\n\n")
 	cat("\nEpidemic threshold:\n")
	print(threshold)
 	cat("\n\nIntensity thresholds:\n")
	print(values)
}
