% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fuel_windAdjustmentFactor}
\alias{fuel_windAdjustmentFactor}
\title{Wind adjustment factor for Rothermel's model}
\usage{
fuel_windAdjustmentFactor(
  topShrubHeight,
  bottomCanopyHeight,
  topCanopyHeight,
  canopyCover
)
}
\arguments{
\item{topShrubHeight}{Shrub stratum top height (in m).}

\item{bottomCanopyHeight}{Canopy base height (in m).}

\item{topCanopyHeight}{Canopy top height (in m).}

\item{canopyCover}{Canopy percent cover.}
}
\value{
A scalar value between 0 and 1
}
\description{
Function fuel_windAdjustmentFactor determines the adjustment factor of wind for surface fires, according to Andrews (2012).
}
\examples{
#Load example plot plant data
 data(exampleforest)
  
#Default species parameterization
data(SpParamsMED)

#Calculate fuel properties according to FCCS
fccs <- fuel_FCCS(exampleforest, SpParamsMED)

# Estimate wind adjustment factor
fuel_windAdjustmentFactor(fccs$htc[2], fccs$hbc[1], fccs$htc[1], fccs$cover[1])

}
\references{
Andrews, P. L. 2012. Modeling wind adjustment factor and midflame wind speed for Rothermel’s surface fire spread model. USDA Forest Service - General Technical Report RMRS-GTR:1–39.
}
\keyword{internal}
