% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_binaryclass.R
\name{TPR}
\alias{TPR}
\title{True positive rate}
\usage{
TPR(truth, response, positive)
}
\arguments{
\item{truth}{vector of true values}

\item{response}{vector of predicted values}

\item{positive}{positive class}
}
\description{
Percentage of correctly classified observations in the positive class. Also called hit rate or recall or sensitivity.
}
\examples{
n = 20
set.seed(125)
truth = as.factor(sample(c(1,0), n, replace = TRUE))
probabilities = runif(n)
response = as.factor(as.numeric(probabilities > 0.5))
positive = 1
TPR(truth, response, positive)
}
