% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_multilabel.R
\name{MultilabelHamloss}
\alias{MultilabelHamloss}
\title{Hamming loss}
\usage{
MultilabelHamloss(truth, response)
}
\arguments{
\item{truth}{matrix of true values}

\item{response}{matrix of predicted values}
}
\description{
Proportion of labels that are predicted incorrectly, following the definition
by Charte and Charte: https://journal.r-project.org/archive/2015-2/charte-charte.pdf.
}
\examples{
n = 20
set.seed(122)
truth = matrix(sample(c(0,1), 60, replace = TRUE), 20, 3)
response = matrix(sample(c(0,1), 60, replace = TRUE), 20, 3)
MultilabelHamloss(truth, response)
}
