% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nterms.R
\name{nterms.mcmc}
\alias{nterms.mcmc}
\title{Number of Terms}
\usage{
\method{nterms}{mcmc}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
A integer scalar of the number of terms.
}
\description{
Gets the number of terms
of an MCMC object.
}
\examples{
\dontshow{if (requireNamespace("nlist", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(nlist)

nterms(nlist(x = 2))
nterms(nlist(x = NA_real_))
nterms(nlist(x = 3, zz = matrix(2:5, 2)))
nterms(nlists(
  nlist(y = 3, zz = matrix(2:5, 2)),
  nlist(y = 5, zz = matrix(1:4, 2))
))
\dontshow{\}) # examplesIf}
}
\seealso{
Other MCMC dimensions: 
\code{\link[universals]{nchains}()},
\code{\link[universals]{niters}()},
\code{\link[universals]{npars}()},
\code{\link[universals]{nsams}()},
\code{\link[universals]{nsims}()}
}
