% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_dexp_gold.R
\name{mc_dexp_gold}
\alias{mc_dexp_gold}
\title{Exponential-matrix and its derivatives}
\usage{
mc_dexp_gold(M, dM)
}
\arguments{
\item{M}{A matrix.}

\item{dM}{A matrix.}
}
\value{
A list with two elements: \eqn{expm(M)} and its derivatives.
}
\description{
Given a matrix \eqn{M} and its derivative \eqn{dM} the
    function \code{dexp_gold} returns the exponential-matrix
    \eqn{expm(M)} and its derivative. This function is based on the
    \code{\link[Matrix]{expm}} function. It is not really used in the
    package, but I keep this function to test my own implementation
    based on eigen values decomposition.
}
\examples{
M <- matrix(c(1,0.8,0.8,1), 2,2)
dM <- matrix(c(0,1,1,0),2,2)
mcglm::mc_dexp_gold(M = M, dM = dM)
}
\seealso{
\code{\link[Matrix]{expm}}, \code{\link[base]{eigen}}.
}
\author{
Wagner Hugo Bonat
}
\keyword{internal}
