% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgf_rs.R
\name{is.mcgf_rs}
\alias{is.mcgf_rs}
\alias{as.mcgf_rs}
\title{Check if an object is an \code{mcgf_rs} object..}
\usage{
is.mcgf_rs(x)

as.mcgf_rs(x, label, ncores = 1)
}
\arguments{
\item{x}{An Object.}

\item{label}{A vector of regime labels. Its length must be the same as
the number rows in \code{data}.}

\item{ncores}{Number of cpu cores used for computing in \verb{[ccfs()]}.}
}
\value{
\code{is.mcgf_rs} returns a logical valud; TRUE if \code{x} is of the \code{mcgf_rs}
class. \code{as.mcgf_rs} coerces an \code{mcgf} object to an \code{mcgf_rs} object by adding
regime labels. Fitted base or Lagrangian models in \code{x} are kept.
}
\description{
Check if an object is an \code{mcgf_rs} object..
}
\examples{
data(sim2)
is.mcgf_rs(sim2)

sim2_mcgf <- mcgf(sim2$data, dists = sim2$dists)
is.mcgf_rs(sim2_mcgf)

sim2_mcgf <- mcgf_rs(sim2$data, dists = sim2$dists, label = sim2$label)
is.mcgf_rs(sim2_mcgf)
data(sim2)
sim2_mcgf <- mcgf(sim2$data, dists = sim2$dists)
sim2_mcgf <- as.mcgf_rs(sim2_mcgf, label = sim2$label)
}
