% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotmc.R
\name{ggplotmc}
\alias{ggplotmc}
\alias{ggplotmc.mc}
\alias{ggplotmc.mcnode}
\title{ggplotmc}
\usage{
ggplotmc(x, ...)

\method{ggplotmc}{mcnode}(
  x,
  prec = 0.001,
  stat = c("median", "mean"),
  lim = c(0.025, 0.25, 0.75, 0.975),
  na.rm = TRUE,
  griddim = NULL,
  xlab = NULL,
  ylab = "Fn(x)",
  main = "",
  paint = TRUE,
  xlim = NULL,
  ylim = NULL,
  which = NULL,
  ...
)

\method{ggplotmc}{mc}(
  x,
  prec = 0.001,
  stat = c("median", "mean"),
  lim = c(0.025, 0.25, 0.75, 0.975),
  na.rm = TRUE,
  griddim = NULL,
  xlab = NULL,
  ylab = "Fn(x)",
  main = "",
  paint = TRUE,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{and `mc` or an `mcnode` object}

\item{...}{further arguments to be passed to [ggplot2::stat_ecdf()]}

\item{prec}{the precision of the plot. 0.001 will provide an ecdf using the 0.000, 0.001, .002, ..., 1.000 quantiles.}

\item{stat}{the function used for estimates (2D `mc` or `mcnode`). By default the median.}

\item{lim}{a  vector of numbers (between 0 and 1) indicating the envelope (2D `mc` or `mcnode`) . Maybe NULL or empty.}

\item{na.rm}{Should `NA` values be discarded}

\item{griddim}{a vector of two integers, indicating the size of the grid of the graph. If NULL, the grid is calculated to produce a "nice" graph.}

\item{xlab}{vector of labels for the x-axis. If `NULL`, the name of the node is used.}

\item{ylab}{vector of labels for the y-axis.}

\item{main}{vector of main titles of the graph}

\item{paint}{Should the envelopes be filled?}

\item{xlim}{x coordinate range. `xlim` is either a vector of length 2, used for each graph, or a list of vectors of length 2, whose ith element is used for the ith graph. By default, the data range is used as xlim.}

\item{ylim}{y coordinate range. `ylim` is either a vector of length 2, used for each graph, or a list of vectors of length 2, whose ith element is used for the ith graph. By default, the data range is 0-1.}

\item{which}{An argument used for an `mcnode` with multivariates. Can specify which variate plot to display. When variates are more than one, the output will be saved in a plot list by default or use the number of which variate to display.}
}
\value{
a ggplot object.
}
\description{
Plots the empirical cumulative distribution function of a [mcnode] 
or a [mc] object ("`0`" and "`V`" nodes) or the empirical cumulative distribution 
function of the estimate of a [mcnode] or [mc] object ("`U`" and "`VU`" nodes) based on 
[ggplot2::ggplot] package.
}
\examples{
data(total)
# When mcnode has one variate
ggplotmc(xV)
# Post process
ggplotmc(xV) + ggplot2::ggtitle("post processed")
# When mcnode has two variates
gplots <- ggplotmc(xVUM) #will save two plots in a list
gplots[[1]] # show the first variate plot of xVUM mcnode
ggplotmc(xVUM, which = 1) #directly show the first variate plot of xVUM mcnode

}
\seealso{
[plot.mc()]
}
\author{
Yu Chen and Regis Pouillot
}
