% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{count_vals_byname}
\alias{count_vals_byname}
\title{Count the number of matrix entries that meet a criterion}
\usage{
count_vals_byname(
  a,
  compare_fun = c("==", "!=", "<", "<=", ">=", ">"),
  val = 0
)
}
\arguments{
\item{a}{A matrix or list of matrices whose values are to be counted according to \code{compare_fun}.}

\item{compare_fun}{The comparison function, one of "==", "!=",
"<", "<=", ">", or ">=".
Default is "==".}

\item{val}{The value against which matrix entries are compared.
Default is \code{0}.}
}
\value{
An integer indicating the number of entries in \code{a}
that meet the specified criterion
}
\description{
Expressions can be written in a natural way such as
\code{count_vals_byname(m, "<=", 1)}.
}
\details{
Either a single matrix or a list of matrices can be given as the \code{a} argument.
\code{compare_fun} can be specified as a string ("!=")
or as a back-quoted function (\code{`!=`}).
}
\examples{
m <- matrix(c(0, 1, 2, 3, 4, 0), nrow = 3, ncol = 2)
count_vals_byname(m) # uses defaults: compare_fun = "==" and val = 0
count_vals_byname(m, compare_fun = "!=")
count_vals_byname(m, compare_fun = `!=`)
# Write expressions in a natural way
count_vals_byname(m, "<=", 1)
# Also works for lists
count_vals_byname(list(m,m), "<=", 1)
}
