% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windowfunc.R
\name{mov_mean}
\alias{mov_mean}
\alias{mov_var}
\alias{mov_sum}
\alias{mov_max}
\alias{mov_min}
\alias{mov_std}
\alias{movmean_std}
\alias{muinvn}
\title{Several moving window functions}
\usage{
mov_mean(
  data,
  window_size,
  type = c("ogita", "normal", "weighted", "fading"),
  eps = 0.9
)

mov_var(
  data,
  window_size,
  type = c("ogita", "normal", "weighted", "fading"),
  eps = 0.9
)

mov_sum(
  data,
  window_size,
  type = c("ogita", "normal", "weighted", "fading"),
  eps = 0.9
)

mov_max(data, window_size)

mov_min(data, window_size)

mov_std(data, window_size, rcpp = TRUE)

movmean_std(data, window_size, rcpp = TRUE)

muinvn(data, window_size, rcpp = TRUE, n_workers = 1)
}
\arguments{
\item{data}{A \code{vector} or a column \code{matrix} of \code{numeric}.}

\item{window_size}{An \code{integer}. The size of the rolling window.}

\item{type}{A \code{string}. Select between several algorithms. Default is \code{ogita} (See details).}

\item{eps}{A \code{numeric}. Used only for fading algorithms (See details), otherwise has no effect.}

\item{rcpp}{A \code{logical}. If \code{TRUE} will use the Rcpp implementation, otherwise will use the R implementation,
that may or not be slower.}

\item{n_workers}{An \code{integer}. The number of threads using for computing. Defaults to \code{1}.}
}
\value{
\code{mov_mean()} returns a \code{vector} with moving \code{avg}.

\code{mov_var()} returns a \code{vector} with moving \code{var}.

\code{mov_sum()} returns a \code{vector} with moving \code{sum}.

\code{mov_max()} returns a \code{vector} with moving \code{max}.

\code{mov_min()} returns a \code{vector} with moving \code{min}.

\code{mov_std()} returns a \code{vector} with moving \code{sd}.

\code{movmean_std()} returns a \code{list} with \code{vectors} of the moving \code{avg}, \code{sd}, \code{sig}, \code{sum} and \code{sqrsum}.

\code{muinvn()} returns a \code{list} with \code{vectors} of moving \code{avg} and \code{sig}.
}
\description{
These functions do not handle NA values
}
\details{
Some functions may use different algorithms to compute the results.
The available types are:
\enumerate{
\item \strong{ogita}: This is the default. It uses the Ogita \emph{et al.}, Accurate Sum, and Dot Product for precision. It is not
the fastest algorithm, but the time spent vs. guarantee of precision worth it.
\item \strong{normal}: This uses the \code{cumsum} method that is faster, but unreliable in some situations (I have to find the
references, but is true).
\item \strong{weighted}: This uses Rodrigues P., \emph{et al.} algorithm that uses a weighted window for online purposes. The
\code{eps} argument controls the factor. (The function is not online yet)
\item \strong{fading}: This also uses Rodrigues P., \emph{et al.} algorithm that in this case, uses a fading factor, also for
online purposes. he \code{eps} argument controls the factor. (The function is not online yet)
}

Another important detail is that the \emph{standard deviation} we use for all computations is the \emph{population} (i.e.:
divided by \code{n}), not the \emph{sample} (i.e.: divided by \code{n - 1}). That is why we also provide the internally the
\verb{:::std()} function that computes the \emph{population}, differently from \code{stats::sd()} that is the \emph{sample} kind. Further
more, \code{movmean_std()} shall be used when you need both results in one computation. This is faster than call
\code{mov_mean()} followed by \code{mov_std()}. Finally, \code{muinvn()} is kept like that for historical reasons, as it is the
function used by \code{mpx()}. It returns the \code{sig} (stable inverse centered norm) instead of \code{std} (\code{sig} is equals to
\code{1 / (std * sqrt(window_size))}).
}
\examples{
mov <- mov_mean(motifs_discords_small, 50)
mov <- mov_var(motifs_discords_small, 50)
mov <- mov_sum(motifs_discords_small, 50)
mov <- mov_max(motifs_discords_small, 50)
mov <- mov_min(motifs_discords_small, 50)
mov <- mov_std(motifs_discords_small, 50)
mov <- movmean_std(motifs_discords_small, 50)
mov <- muinvn(motifs_discords_small, 50)
}
