% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.R
\docType{package}
\name{matrixpls-package}
\alias{matrixpls-package}
\alias{_PACKAGE}
\title{Matrix-based Partial Least Squares estimation}
\description{
\pkg{matrixpls} calculates composite variable models using partial least squares (PLS)
algorithm and related methods. In contrast to most other PLS software which implement
the raw data version of the algorithm, \pkg{matrixpls} works with data covariance matrices. The 
algorithms are designed to be computationally efficient, modular in programming, and well documented.
\pkg{matrixpls} integrates with \pkg{simsem} to enable Monte Carlo simulations with as little custom
programming as possible.
}
\details{
\pkg{matrixpls} calculates models where sets of indicator variables are combined as weighted composites. 
These composites are then used to estimate a statistical model describing the relationships between
the composites and composites and indicators. While a number of such methods exists, the partial
least squares (PLS) technique is perhaps the most widely used.

The \pkg{matrixpls} package implements a collection of PLS techniques as well as the more recent 
GSCA and PLSc techniques and older methods based on analysis with composite variables,
such as regression with
unit weighted composites or factor scores. The package provides a unified
framework that enables the comparison and analysis of these algorithms. In contrast to previous R
packages for PLS, such as \pkg{plspm} and \pkg{semPLS} and all currently
available commercial PLS software, which work with
raw data, \pkg{matrixpls} calculates the indicator weights and model estimates from data covariance 
matrices. Working with covariance data allows for reanalyzing covariance matrices that are sometimes
published as appendices of articles, is computationally more efficient, and lends itself more easily
for formal analysis than implementations based on raw data. 

\pkg{matrixpls} has modular design that is easily expanded and contains more calculation options
than the two other PLS packages for R. To allow validation of the algorithms by end users
and to help porting existing analysis files from the two other R packages to 
\pkg{matrixpls}, the package contains compatibility functions for both \pkg{plspm} and \pkg{semPLS}.

The desing principles and functionality of the package is best explained by first explaining the main
function \code{matrixpls}. The function performs two tasks. It first calculates a set of indicator 
weights to form composites based on data covariance matrix and then estimates a statistical model
with the indicators and composites using the weights. The main function takes the following arguments:

\preformatted{
matrixpls(S, model, W.model = NULL, 
          weightFun = weightFun.pls, 
          parameterEstim = parameterEstim.separate,
          weightSign = NULL, ..., 
          validateInput = TRUE, standardize = TRUE)
}

The first five arguments of \code{\link{matrixpls}} are most relevant for understanding how the package
works. \code{S}, is the data covariance or correlation matrix. \code{model} defines the model
which is estimated in the second stage and \code{W.model} defines how the indicators are to be
aggregated as composites. If \code{W.model} is left undefined, it will be constructed based on
\code{model} following rules that are explained elsewhere in the documentation.
\code{weightFun} and 
\code{parameterEstim} are functions that 
implement the first and second task of the function respectively. All other arguments are passed 
down to these two functions, which in turn can pass arguments to other functions that they call.


Many of the commonly used arguments of \code{matrixpls} function are functions themselves. For 
example, executing a PLS analysis with Mode B outer estimation for all indicator blocks and centroid inner 
estimation could be specified as follows:

\preformatted{
matrixpls(S, model, 
          outerEstim = outerEstim.modeB,
          innerEstim = innerEstim.centroid)
}

The arguments \code{outerEstim} and \code{innerEstim} are not defined by the
\code{matrixpls} function, but are passed down to \code{weightFun.pls} which is used as the default
\code{weightFun}. \code{outerEstim.modeB} and \code{innerEstim.centroid} are themselves functions provided
by the \pkg{matrixpls} package, which perform the actual inner and outer estimation stages of the
PLS algorithm. Essentially, all parts of the estimation algorithm can be provided as arguments for
the main function. This allows for adjusting the inner workings of the algorithm in a way that is
currently not possible with any other PLS software.

It is also possible to define custom functions. For example, we could define a new Mode B outer
estimator that only produces positive weights by creating a custom function:

\preformatted{
myModeB <- function(...)\{
  abs(outerEstim.ModeB(...))
\}

matrixpls(S, model,
          outerEstim = myModeB,
          innerEstim = innerEstim.centroid)
}

Model can be specified in the lavaan format or the native matrixpls format.
The native model format is a list of three binary matrices, \code{inner}, \code{reflective},
and \code{formative} specifying the free parameters of a model: \code{inner} (\code{l x l}) specifies the 
regressions between composites, \code{reflective} (\code{k x l}) specifies the regressions of observed
data on composites, and \code{formative} (\code{l x k}) specifies the regressions of composites on the
observed data. Here \code{k} is the number of observed variables and \code{l} is the number of composites.

If the model is specified in lavaan format, the native
format model is derived from this model by assigning all regressions between latent
variables to \code{inner}, all factor loadings to \code{reflective}, and all regressions
of latent variables on observed variables to \code{formative}. Regressions between
observed variables and all free covariances are ignored. All parameters that are
specified in the model will be treated as free parameters.

The original papers about Partial Least Squares, as well as many of the current PLS
implementations, impose restrictions on the matrices \code{inner},
\code{reflective}, and \code{formative}: \code{inner} must be a lower triangular matrix,
\code{reflective} must have exactly one non-zero value on each row and must have at least
one non-zero value on each column, and \code{formative} must only contain zeros.
Some PLS implementations allow \code{formative} to contain non-zero values, but impose a
restriction that the sum of \code{reflective} and \code{t(formative)} must satisfy
the original restrictions of \code{reflective}. The only restrictions that matrixpls
imposes on \code{inner}, \code{reflective}, and \code{formative} is that these must be
binary matrices and that the diagonal of \code{inner} must be zeros.
}
\references{
Rosseel, Y. (2012). lavaan: An R Package for Structural Equation Modeling. \emph{Journal of Statistical Software}, 48(2), 1–36. Retrieved from http://www.jstatsoft.org/v48/i02

Lohmöller J.-B. (1989) \emph{Latent variable path modeling with partial least squares.} Heidelberg: Physica-Verlag.

Rönkkö, M., McIntosh, C. N., & Antonakis, J. (2015). On the adoption of partial least squares in psychological research: Caveat emptor. \emph{Personality and Individual Differences}, (87), 76–84. \href{http://doi.org/10.1016/j.paid.2015.07.019}{DOI:10.1016/j.paid.2015.07.019}

Wold, H. (1982). Soft modeling - The Basic Design And Some Extensions. In K. G. Jöreskog & S. Wold (Eds.),\emph{Systems under indirect observation: causality, structure, prediction} (pp. 1–54). Amsterdam: North-Holland.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mronkko/matrixpls}
  \item Report bugs at \url{https://github.com/mronkko/matrixpls/issues}
}

}
\author{
\strong{Maintainer}: Mikko Rönkkö \email{mikko.ronkko@jyu.fi}

}
