% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABCXYZanalysis.R
\docType{methods}
\name{plot,ABCXYZData,ANY-method}
\alias{plot,ABCXYZData,ANY-method}
\title{Plots the result of an ABC/XYZ analysis}
\usage{
\S4method{plot}{ABCXYZData,ANY}(
  x,
  plot_engine = c("graphics", "plotly"),
  title = "",
  xlab = "",
  ylab = "",
  top5lab = NA,
  color = list(itemColor = "blue", top5Color = "black", aColor = "green", bColor =
    "orange", cColor = "red"),
  item = NA,
  ...
)
}
\arguments{
\item{x}{Object of class \code{ABCXYZData}.}

\item{plot_engine}{Name of the plot engine ("graphics", "plotly")}

\item{title}{Plot title (e.g. 'ABC-Analysis').}

\item{xlab}{Label of x-axis (e.g. 'Percentage of Items').}

\item{ylab}{Label of y-axis (e.g. 'Percentage of cumulative Value').}

\item{top5lab}{Title of the rank of the top 5 items (e.g. 'Items with the highest Value').}

\item{color}{List of plot colors (i.e., itemColor, top5Color, aColor, bColor, cColor).
Default is \code{list(itemColor = "blue", top5Color = "black", aColor = "green", bColor = "orange", cColor = "red")}.}

\item{item}{Name of a single column with an identifier, that is displayed in the top-5-ranking.
Used if the \code{ABCXYZData} object has multiple item columns. If \code{NA} the first item
column is displayed.}

\item{...}{Further optional parameters for function \code{graphics::plot} or function \code{plotly::plot_ly}.}
}
\description{
Plots a graph that shows what percentage of items is responsible for what amount of value.
}
\examples{
data("Amount")
abcResult = computeABCXYZAnalysis(data = Amount,
    value = "value",
    item = "item",
    timestamp = "date")
plot(abcResult,
     plot_engine = "graphics",
     title = "ABC Analysis",
     xlab = "Items",
     ylab = "Demand")
}
\seealso{
\code{\link{computeABCXYZAnalysis}} \code{\link[=ABCXYZData-class]{ABCXYZData}}
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{methods}
