## ----echo = FALSE-------------------------------------------------------------
knitr::opts_chunk$set(
  warning = FALSE,
  message = FALSE
)
options(digits=4)

## -----------------------------------------------------------------------------
A <- matrix(c(13, -4, 2, -4, 11, -2, 2, -2, 8), 3, 3, byrow=TRUE)
A

## -----------------------------------------------------------------------------
ev <- eigen(A)
# extract components
(values <- ev$values)
(vectors <- ev$vectors)

## -----------------------------------------------------------------------------
crossprod(vectors)
zapsmall(crossprod(vectors))

## -----------------------------------------------------------------------------
library(matlib)   # use the matlib package
tr(A)
sum(values)

## -----------------------------------------------------------------------------
sum(A^2)
sum(values^2)

## -----------------------------------------------------------------------------
det(A)
prod(values)

## -----------------------------------------------------------------------------
R(A)
sum(values != 0)

## -----------------------------------------------------------------------------
AI <- solve(A)
AI
eigen(AI)$values
eigen(AI)$vectors

## -----------------------------------------------------------------------------
eigen(A %*% A)
eigen(A %*% A %*% A)$values
eigen(mpower(A, 4))$values


