% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{checkStability}
\alias{checkStability}
\title{Check if a two-sided matching is stable}
\usage{
checkStability(proposerUtils, reviewerUtils, proposals, engagements)
}
\arguments{
\item{proposerUtils}{is a matrix with cardinal utilities of the proposing side of the
market}

\item{reviewerUtils}{is a matrix with cardinal utilities of the courted side of the
market}

\item{proposals}{is a matrix that contains the id of the reviewer that a given
proposer is matched to: the first row contains the id of the reviewer that is
matched with the first proposer, the second row contains the id of the reviewer
that is matched with the second proposer, etc. The column dimension accommodates
proposers with multiple slots.}

\item{engagements}{is a matrix that contains the id of the proposer that a given
reviewer is matched to. The column dimension accommodates reviewers with multiple
slots}
}
\value{
true if the matching is stable, false otherwise
}
\description{
This function checks if a given matching is stable for a particular set of
preferences. This function can check if a given check one-to-one,
one-to-many, or many-to-one matching is stable.
}

