/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.objects;

import choco.kernel.common.util.objects.ISparseMatrix;
import java.util.Arrays;
import java.util.Iterator;

public class BooleanSparseMatrix
implements ISparseMatrix {
    private long[] elements;
    private int nbElement;
    final int size;

    public BooleanSparseMatrix(int n) {
        this.size = n;
        this.elements = new long[n];
        this.nbElement = 0;
    }

    @Override
    public void add(int i, int j) {
        this.ensureCapacity(this.nbElement + 1);
        long v = (long)Math.min(i, j) * (long)this.size + (long)Math.max(i, j);
        this.elements[this.nbElement++] = v;
    }

    private void ensureCapacity(int nsize) {
        if (this.elements.length < nsize) {
            long[] oldElements = new long[nsize * 3 / 2];
            System.arraycopy(this.elements, 0, oldElements, 0, this.elements.length);
            this.elements = oldElements;
        }
    }

    @Override
    public int getNbElement() {
        return this.nbElement;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < BooleanSparseMatrix.this.nbElement;
            }

            @Override
            public Long next() {
                return BooleanSparseMatrix.this.elements[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void prepare() {
        long[] n = new long[this.nbElement];
        System.arraycopy(this.elements, 0, n, 0, this.nbElement);
        Arrays.sort(n);
        this.elements = n;
    }
}

