/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints;

import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.ITemporalRelation;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;

public class TemporalConstraint
extends ComponentConstraint
implements ITemporalRelation<TaskVariable, IntegerVariable> {
    private static final long serialVersionUID = 5410687647692627875L;

    public TemporalConstraint(ConstraintType constraintType, Object parameters, Variable[] variables) {
        super(constraintType, parameters, variables);
    }

    public final boolean isInPreprocess() {
        assert (this.checkDomains());
        if (this.getParameters() instanceof Boolean) {
            return (Boolean)this.getParameters() != false && this.getForwardSetup().getLowB() >= 0 && this.getBackwardSetup().getLowB() >= 0;
        }
        return false;
    }

    public final boolean checkDomains() {
        return this.getDirection().isBoolean() && this.getForwardSetup().isConstant() && this.getBackwardSetup().isConstant();
    }

    @Override
    public final TaskVariable getOrigin() {
        return (TaskVariable)this.getVariable(0);
    }

    public final int getOHook() {
        return this.getOrigin().getHook();
    }

    public final IntegerVariable getForwardSetup() {
        return (IntegerVariable)this.getVariable(1);
    }

    @Override
    public final int forwardSetup() {
        return this.getForwardSetup().getLowB();
    }

    public final void setForwardSetup(int val) {
        this.replaceByConstantAt(1, val);
    }

    @Override
    public final TaskVariable getDestination() {
        return (TaskVariable)this.getVariable(2);
    }

    public final int getDHook() {
        return this.getDestination().getHook();
    }

    public final IntegerVariable getBackwardSetup() {
        return (IntegerVariable)this.getVariable(3);
    }

    @Override
    public final int backwardSetup() {
        return this.getBackwardSetup().getLowB();
    }

    public final void setBackwardSetup(int val) {
        this.replaceByConstantAt(3, val);
    }

    @Override
    public final IntegerVariable getDirection() {
        return (IntegerVariable)this.getVariable(4);
    }

    @Override
    public final boolean isFixed() {
        return this.getDirection().isConstant();
    }

    @Override
    public int getDirVal() {
        return this.getDirection().getLowB();
    }

    @Override
    public String toString() {
        return this.pretty();
    }
}

