/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.variables.scheduling;

import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.ITimePeriodList;
import java.awt.Point;

public abstract class AbstractTask
implements ITask {
    private final ITimePeriodList timePeriodList;

    public AbstractTask() {
        this.timePeriodList = new SingleTimePeriod();
    }

    public AbstractTask(ITimePeriodList timePeriodList) {
        this.timePeriodList = timePeriodList;
    }

    @Override
    public String getName() {
        return "T" + this.getID();
    }

    @Override
    public boolean hasConstantDuration() {
        return this.getMinDuration() == this.getMaxDuration();
    }

    @Override
    public int getECT() {
        return this.getEST() + this.getMinDuration();
    }

    @Override
    public int getLST() {
        return this.getLCT() - this.getMinDuration();
    }

    @Override
    public String toDotty() {
        return StringUtils.toDotty(this, null, true, new String[0]);
    }

    @Override
    public String pretty() {
        return StringUtils.pretty(this);
    }

    public String toString() {
        return this.pretty();
    }

    @Override
    public boolean isScheduled() {
        return this.timePeriodList.getExpendedDuration() == this.getMaxDuration();
    }

    @Override
    public final boolean isPartiallyScheduled() {
        return !this.timePeriodList.isEmpty();
    }

    @Override
    public final boolean isInterrupted() {
        return this.timePeriodList.getTimePeriodCount() > 1;
    }

    @Override
    public final ITimePeriodList getTimePeriodList() {
        return this.timePeriodList;
    }

    private final class SingleTimePeriod
    implements ITimePeriodList {
        private SingleTimePeriod() {
        }

        @Override
        public final void reset() {
        }

        @Override
        public final int getExpendedDuration() {
            return AbstractTask.this.getECT() - AbstractTask.this.getLST();
        }

        @Override
        public final boolean isEmpty() {
            return this.getExpendedDuration() <= 0;
        }

        @Override
        public final int getTimePeriodCount() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public final Point getTimePeriod(int i) {
            return i == 0 && !this.isEmpty() ? new Point(AbstractTask.this.getLST(), AbstractTask.this.getECT()) : null;
        }

        @Override
        public int getPeriodFirst() {
            return AbstractTask.this.getLST();
        }

        @Override
        public int getPeriodLast() {
            return AbstractTask.this.getECT();
        }

        @Override
        public final int getPeriodStart(int i) {
            return i == 0 ? AbstractTask.this.getLST() : -21474836;
        }

        @Override
        public final int getPeriodEnd(int i) {
            return i == 0 ? AbstractTask.this.getECT() : -21474836;
        }
    }
}

