/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.automaton.penalty;

import choco.kernel.model.constraints.automaton.penalty.AbstractPenaltyFunction;

public class LinearPenaltyFunction
extends AbstractPenaltyFunction {
    private int min;
    private int minPref;
    private int minPenalty;
    private int max;
    private int maxPref;
    private int maxPenalty;

    public LinearPenaltyFunction(int min, int minPref, int minPenalty, int max, int maxPref, int maxPenalty) {
        this.min = min;
        this.max = max;
        this.minPref = minPref;
        this.maxPref = maxPref;
        this.minPenalty = minPenalty;
        this.maxPenalty = maxPenalty;
    }

    @Override
    public int penalty(int value) {
        if (value < this.minPref) {
            if (value >= this.min) {
                return (this.minPref - value) * this.minPenalty;
            }
            return Integer.MAX_VALUE;
        }
        if (value > this.maxPref) {
            if (value <= this.max) {
                return (value - this.maxPref) * this.maxPenalty;
            }
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

