/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.iterators;

import choco.kernel.common.util.disposable.PoolManager;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.common.util.iterators.IStored;

public final class SingleElementIterator<E>
extends DisposableIterator<E>
implements IStored {
    private static final ThreadLocal<PoolManager<SingleElementIterator>> manager = new ThreadLocal();
    private E elem;
    private boolean hnext;
    private boolean isStored;

    private SingleElementIterator() {
    }

    public static <E> SingleElementIterator getIterator(E element) {
        SingleElementIterator<E> it;
        PoolManager<SingleElementIterator<E>> tmanager = manager.get();
        if (tmanager == null) {
            tmanager = new PoolManager();
            manager.set(tmanager);
        }
        if ((it = tmanager.getE()) == null) {
            it = new SingleElementIterator<E>();
        }
        it.init(element);
        return it;
    }

    private void init(E anElement) {
        super.init();
        this.elem = anElement;
        this.hnext = true;
    }

    @Override
    public boolean hasNext() {
        return this.hnext;
    }

    @Override
    public E next() {
        this.hnext = false;
        return this.elem;
    }

    @Override
    public void dispose() {
        super.dispose();
        manager.get().returnE(this);
    }

    @Override
    public void push() {
        this.isStored = true;
    }

    @Override
    public void pop() {
        this.isStored = false;
    }

    @Override
    public boolean isStored() {
        return this.isStored;
    }
}

