/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.variables.real;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.variables.real.RealInterval;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import java.util.logging.Logger;

public class RealMath {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    public static final double ZERO = 0.0;
    public static final double NEG_ZER0 = -0.0;

    public static double nextFloat(double x) {
        if (x < 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(x) - 1L);
        }
        if (x == 0.0) {
            return Double.longBitsToDouble(1L);
        }
        if (x < Double.POSITIVE_INFINITY) {
            return Double.longBitsToDouble(Double.doubleToLongBits(x) + 1L);
        }
        return x;
    }

    public static double prevFloat(double x) {
        if (x == 0.0) {
            return -RealMath.nextFloat(0.0);
        }
        return -RealMath.nextFloat(-x);
    }

    public static RealInterval add(RealInterval x, RealInterval y) {
        return new RealIntervalConstant(RealMath.prevFloat(x.getInf() + y.getInf()), RealMath.nextFloat(x.getSup() + y.getSup()));
    }

    public static RealInterval sub(RealInterval x, RealInterval y) {
        return new RealIntervalConstant(RealMath.prevFloat(x.getInf() - y.getSup()), RealMath.nextFloat(x.getSup() - y.getInf()));
    }

    public static RealInterval mul(RealInterval x, RealInterval y) {
        double s;
        double i;
        if (x.getInf() == 0.0 && x.getSup() == 0.0 || y.getInf() == 0.0 && y.getSup() == 0.0) {
            i = 0.0;
            s = -0.0;
        } else if (x.getInf() >= 0.0) {
            if (y.getInf() >= 0.0) {
                i = Math.max(0.0, RealMath.prevFloat(x.getInf() * y.getInf()));
                s = RealMath.nextFloat(x.getSup() * y.getSup());
            } else if (y.getSup() <= 0.0) {
                i = RealMath.prevFloat(x.getSup() * y.getInf());
                s = Math.min(0.0, RealMath.nextFloat(x.getInf() * y.getSup()));
            } else {
                i = RealMath.prevFloat(x.getSup() * y.getInf());
                s = RealMath.nextFloat(x.getSup() * y.getSup());
            }
        } else if (x.getSup() <= 0.0) {
            if (y.getInf() >= 0.0) {
                i = RealMath.prevFloat(x.getInf() * y.getSup());
                s = Math.min(0.0, RealMath.nextFloat(x.getSup() * y.getInf()));
            } else if (y.getSup() <= 0.0) {
                i = Math.max(0.0, RealMath.prevFloat(x.getSup() * y.getSup()));
                s = RealMath.nextFloat(x.getInf() * y.getInf());
            } else {
                i = RealMath.prevFloat(x.getInf() * y.getSup());
                s = RealMath.nextFloat(x.getInf() * y.getInf());
            }
        } else if (y.getInf() >= 0.0) {
            i = RealMath.prevFloat(x.getInf() * y.getSup());
            s = RealMath.nextFloat(x.getSup() * y.getSup());
        } else if (y.getSup() <= 0.0) {
            i = RealMath.prevFloat(x.getSup() * y.getInf());
            s = RealMath.nextFloat(x.getInf() * y.getInf());
        } else {
            i = Math.min(RealMath.prevFloat(x.getInf() * y.getSup()), RealMath.prevFloat(x.getSup() * y.getInf()));
            s = Math.max(RealMath.nextFloat(x.getInf() * y.getInf()), RealMath.nextFloat(x.getSup() * y.getSup()));
        }
        return new RealIntervalConstant(i, s);
    }

    public static RealInterval odiv(RealInterval x, RealInterval y) {
        double s;
        double i;
        if (y.getInf() <= 0.0 && y.getSup() >= 0.0) {
            throw new UnsupportedOperationException();
        }
        double yl = y.getInf();
        double yh = y.getSup();
        if (yh == 0.0) {
            yh = -0.0;
        }
        if (x.getInf() >= 0.0) {
            if (yl >= 0.0) {
                i = Math.max(0.0, RealMath.prevFloat(x.getInf() / yh));
                s = RealMath.nextFloat(x.getSup() / yl);
            } else {
                i = RealMath.prevFloat(x.getSup() / yh);
                s = Math.min(0.0, RealMath.nextFloat(x.getInf() / yl));
            }
        } else if (x.getSup() <= 0.0) {
            if (yl >= 0.0) {
                i = RealMath.prevFloat(x.getInf() / yl);
                s = Math.min(0.0, RealMath.nextFloat(x.getSup() / yh));
            } else {
                i = Math.max(0.0, RealMath.prevFloat(x.getSup() / yl));
                s = RealMath.nextFloat(x.getInf() / yh);
            }
        } else if (yl >= 0.0) {
            i = RealMath.prevFloat(x.getInf() / yl);
            s = RealMath.nextFloat(x.getSup() / yl);
        } else {
            i = RealMath.prevFloat(x.getSup() / yh);
            s = RealMath.nextFloat(x.getInf() / yh);
        }
        return new RealIntervalConstant(i, s);
    }

    public static RealInterval odiv_wrt(RealInterval x, RealInterval y, RealInterval res) {
        if (y.getInf() > 0.0 || y.getSup() < 0.0) {
            return RealMath.odiv(x, y);
        }
        double resl = res.getInf();
        double resh = res.getSup();
        if (x.getInf() >= 0.0) {
            double tmp_neg = RealMath.nextFloat(x.getInf() / y.getInf());
            double tmp_pos = RealMath.prevFloat(x.getInf() / y.getSup());
            if ((resl > tmp_neg || resl == 0.0) && resl < tmp_pos) {
                resl = tmp_pos;
            }
            if ((resh < tmp_pos || resh == 0.0) && resh > tmp_neg) {
                resh = tmp_neg;
            }
        } else if (x.getSup() <= 0.0) {
            double tmp_neg = RealMath.nextFloat(x.getSup() / y.getSup());
            double tmp_pos = RealMath.nextFloat(x.getSup() / y.getInf());
            if ((resl > tmp_neg || resl == 0.0) && resl < tmp_pos) {
                resl = tmp_pos;
            }
            if ((resh < tmp_pos || resh == 0.0) && resh > tmp_neg) {
                resh = tmp_neg;
            }
        }
        return new RealIntervalConstant(resl, resh);
    }

    public static boolean isCanonical(RealInterval i, double precision) {
        double inf = i.getInf();
        double sup = i.getSup();
        if (sup - inf < precision) {
            return true;
        }
        return RealMath.nextFloat(inf) >= sup;
    }

    public static RealInterval firstHalf(RealInterval i) {
        double sup;
        double inf = i.getInf();
        if (inf == Double.NEGATIVE_INFINITY) {
            inf = -1.7976931348623157E308;
        }
        if ((sup = i.getSup()) == Double.POSITIVE_INFINITY) {
            sup = Double.MAX_VALUE;
        }
        return new RealIntervalConstant(i.getInf(), inf + sup / 2.0 - inf / 2.0);
    }

    public static RealInterval secondHalf(RealInterval i) {
        double sup;
        double inf = i.getInf();
        if (inf == Double.NEGATIVE_INFINITY) {
            inf = -1.7976931348623157E308;
        }
        if ((sup = i.getSup()) == Double.POSITIVE_INFINITY) {
            sup = Double.MAX_VALUE;
        }
        return new RealIntervalConstant(inf + sup / 2.0 - inf / 2.0, i.getSup());
    }

    public static double iPower_lo(double x, int p) {
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        return RealMath.prevFloat(Math.exp(RealMath.prevFloat((double)p * RealMath.prevFloat(Math.log(x)))));
    }

    public static double iPower_up(double x, int p) {
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        return RealMath.nextFloat(Math.exp(RealMath.nextFloat((double)p * RealMath.nextFloat(Math.log(x)))));
    }

    private static RealInterval evenIPower(RealInterval i, int p) {
        double sup;
        double inf;
        if (i.getInf() >= 0.0) {
            if (i.getInf() == Double.POSITIVE_INFINITY) {
                inf = Double.POSITIVE_INFINITY;
                sup = Double.POSITIVE_INFINITY;
            } else {
                inf = RealMath.iPower_lo(i.getInf(), p);
                sup = i.getSup() == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : RealMath.iPower_up(i.getSup(), p);
            }
        } else if (i.getSup() <= 0.0) {
            if (i.getSup() == Double.NEGATIVE_INFINITY) {
                inf = Double.POSITIVE_INFINITY;
                sup = Double.POSITIVE_INFINITY;
            } else {
                inf = RealMath.iPower_lo(-i.getSup(), p);
                sup = i.getInf() == Double.NEGATIVE_INFINITY ? Double.POSITIVE_INFINITY : RealMath.iPower_up(-i.getInf(), p);
            }
        } else {
            inf = 0.0;
            sup = i.getInf() == Double.NEGATIVE_INFINITY || i.getSup() == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : Math.max(RealMath.iPower_up(-i.getInf(), p), RealMath.iPower_up(i.getSup(), p));
        }
        return new RealIntervalConstant(inf, sup);
    }

    public static RealInterval oddIPower(RealInterval i, int p) {
        double sup;
        double inf;
        if (i.getInf() >= 0.0) {
            if (i.getInf() == Double.POSITIVE_INFINITY) {
                inf = Double.POSITIVE_INFINITY;
                sup = Double.POSITIVE_INFINITY;
            } else {
                inf = RealMath.iPower_lo(i.getInf(), p);
                sup = i.getSup() == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : RealMath.iPower_up(i.getSup(), p);
            }
        } else if (i.getSup() <= 0.0) {
            if (i.getSup() == Double.NEGATIVE_INFINITY) {
                inf = Double.NEGATIVE_INFINITY;
                sup = Double.NEGATIVE_INFINITY;
            } else {
                sup = -RealMath.iPower_lo(-i.getSup(), p);
                inf = i.getInf() == Double.NEGATIVE_INFINITY ? Double.NEGATIVE_INFINITY : -RealMath.iPower_up(-i.getInf(), p);
            }
        } else {
            inf = i.getInf() == Double.NEGATIVE_INFINITY ? Double.NEGATIVE_INFINITY : -RealMath.iPower_up(-i.getInf(), p);
            sup = i.getSup() == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : RealMath.iPower_up(i.getSup(), p);
        }
        return new RealIntervalConstant(inf, sup);
    }

    public static RealInterval iPower(RealInterval i, int p) {
        if (p <= 1) {
            throw new UnsupportedOperationException();
        }
        if (p % 2 == 0) {
            return RealMath.evenIPower(i, p);
        }
        return RealMath.oddIPower(i, p);
    }

    public static double iRoot_lo(double x, int p) {
        double d_lo = RealMath.prevFloat(1.0 / (double)p);
        double d_hi = RealMath.nextFloat(1.0 / (double)p);
        if (x == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        if (x < 1.0) {
            return RealMath.prevFloat(Math.exp(RealMath.prevFloat(d_hi * RealMath.prevFloat(Math.log(x)))));
        }
        return RealMath.prevFloat(Math.exp(RealMath.prevFloat(d_lo * RealMath.prevFloat(Math.log(x)))));
    }

    public static double iRoot_up(double x, int p) {
        double d_lo = RealMath.prevFloat(1.0 / (double)p);
        double d_hi = RealMath.nextFloat(1.0 / (double)p);
        if (x == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        if (x < 1.0) {
            return RealMath.nextFloat(Math.exp(RealMath.nextFloat(d_lo * RealMath.nextFloat(Math.log(x)))));
        }
        return RealMath.nextFloat(Math.exp(RealMath.nextFloat(d_hi * RealMath.nextFloat(Math.log(x)))));
    }

    public static RealInterval evenIRoot(RealInterval i, int p, RealInterval res) {
        if (i.getSup() < 0.0) {
            LOGGER.severe("Erreur !!");
        }
        double inf = i.getInf() < 0.0 ? 0.0 : RealMath.iRoot_lo(i.getInf(), p);
        double sup = RealMath.iRoot_up(i.getSup(), p);
        if (res.getSup() < inf) {
            return new RealIntervalConstant(-sup, -inf);
        }
        if (res.getInf() > sup) {
            return new RealIntervalConstant(inf, sup);
        }
        return new RealIntervalConstant(-sup, sup);
    }

    public static RealInterval oddIRoot(RealInterval i, int p) {
        double inf = i.getInf() >= 0.0 ? RealMath.iRoot_lo(i.getInf(), p) : -RealMath.iRoot_up(-i.getInf(), p);
        double sup = i.getSup() >= 0.0 ? RealMath.iRoot_up(i.getSup(), p) : -RealMath.iRoot_lo(-i.getSup(), p);
        return new RealIntervalConstant(inf, sup);
    }

    public static RealInterval iRoot(RealInterval i, int p, RealInterval res) {
        if (p <= 1) {
            throw new UnsupportedOperationException();
        }
        if (p % 2 == 0) {
            return RealMath.evenIRoot(i, p, res);
        }
        return RealMath.oddIRoot(i, p);
    }

    public static RealInterval sinRange(int a, int b) {
        switch (4 * a + b) {
            case 0: {
                LOGGER.severe("Erreur !");
                return null;
            }
            case 1: {
                return new RealIntervalConstant(1.0, 1.0);
            }
            case 2: {
                return new RealIntervalConstant(0.0, 1.0);
            }
            case 3: {
                LOGGER.severe("Erreur !");
                return null;
            }
            case 4: {
                LOGGER.severe("Erreur !");
                return null;
            }
            case 5: {
                LOGGER.severe("Erreur !");
                return null;
            }
            case 6: {
                return new RealIntervalConstant(0.0, 0.0);
            }
            case 7: {
                return new RealIntervalConstant(-1.0, 0.0);
            }
            case 8: {
                return new RealIntervalConstant(-1.0, 0.0);
            }
            case 9: {
                LOGGER.severe("Erreur !");
                return null;
            }
            case 10: {
                LOGGER.severe("Erreur !");
                return null;
            }
            case 11: {
                return new RealIntervalConstant(-1.0, -1.0);
            }
            case 12: {
                return new RealIntervalConstant(0.0, 0.0);
            }
            case 13: {
                return new RealIntervalConstant(0.0, 1.0);
            }
            case 14: {
                LOGGER.severe("Erreur !");
                return null;
            }
            case 15: {
                LOGGER.severe("Erreur !");
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static RealInterval cos(RealInterval interval) {
        if (interval.getSup() - interval.getInf() > RealMath.prevFloat(1.5 * RealMath.prevFloat(Math.PI))) {
            return new RealIntervalConstant(-1.0, 1.0);
        }
        int nlo = interval.getInf() >= 0.0 ? (int)Math.floor(RealMath.prevFloat(RealMath.prevFloat(interval.getInf() * 2.0) / RealMath.nextFloat(Math.PI))) : (int)Math.floor(RealMath.prevFloat(RealMath.prevFloat(interval.getInf() * 2.0) / RealMath.prevFloat(Math.PI)));
        int nup = interval.getSup() >= 0.0 ? (int)Math.floor(RealMath.nextFloat(RealMath.nextFloat(interval.getSup() * 2.0) / RealMath.prevFloat(Math.PI))) : (int)Math.floor(RealMath.nextFloat(RealMath.nextFloat(interval.getSup() * 2.0) / RealMath.nextFloat(Math.PI)));
        if (((nup - nlo) % 4 + 4) % 4 == 3) {
            return new RealIntervalConstant(-1.0, 1.0);
        }
        double clo = Math.min(RealMath.prevFloat(Math.cos(interval.getInf())), RealMath.prevFloat(Math.cos(interval.getSup())));
        double cup = Math.max(RealMath.nextFloat(Math.cos(interval.getInf())), RealMath.nextFloat(Math.cos(interval.getSup())));
        if (((nup - nlo) % 4 + 4) % 4 == 0) {
            return new RealIntervalConstant(clo, cup);
        }
        RealInterval mask = RealMath.sinRange(((nlo + 1) % 4 + 4) % 4, ((nup + 1) % 4 + 4) % 4);
        if (mask.getInf() < clo) {
            clo = mask.getInf();
        }
        if (mask.getSup() > cup) {
            cup = mask.getSup();
        }
        return new RealIntervalConstant(clo, cup);
    }

    public static RealInterval sin(RealInterval interval) {
        if (interval.getSup() - interval.getInf() > RealMath.prevFloat(1.5 * RealMath.prevFloat(Math.PI))) {
            return new RealIntervalConstant(-1.0, 1.0);
        }
        int nlo = interval.getInf() >= 0.0 ? (int)Math.floor(RealMath.prevFloat(RealMath.prevFloat(interval.getInf() * 2.0) / RealMath.nextFloat(Math.PI))) : (int)Math.floor(RealMath.prevFloat(RealMath.prevFloat(interval.getInf() * 2.0) / RealMath.prevFloat(Math.PI)));
        int nup = interval.getSup() >= 0.0 ? (int)Math.floor(RealMath.nextFloat(RealMath.nextFloat(interval.getSup() * 2.0) / RealMath.prevFloat(Math.PI))) : (int)Math.floor(RealMath.nextFloat(RealMath.nextFloat(interval.getSup() * 2.0) / RealMath.nextFloat(Math.PI)));
        if (((nup - nlo) % 4 + 4) % 4 == 3) {
            return new RealIntervalConstant(-1.0, 1.0);
        }
        double clo = Math.min(RealMath.prevFloat(Math.sin(interval.getInf())), RealMath.prevFloat(Math.sin(interval.getSup())));
        double cup = Math.max(RealMath.nextFloat(Math.sin(interval.getInf())), RealMath.nextFloat(Math.sin(interval.getSup())));
        if (((nup - nlo) % 4 + 4) % 4 == 0) {
            return new RealIntervalConstant(clo, cup);
        }
        RealInterval mask = RealMath.sinRange((nlo % 4 + 4) % 4, (nup % 4 + 4) % 4);
        if (mask.getInf() < clo) {
            clo = mask.getInf();
        }
        if (mask.getSup() > cup) {
            cup = mask.getSup();
        }
        return new RealIntervalConstant(clo, cup);
    }

    public static RealInterval asin_wrt(RealInterval interval, RealInterval res) {
        double decInf;
        double decSup;
        double retSup = Double.POSITIVE_INFINITY;
        double retInf = Double.NEGATIVE_INFINITY;
        double asinl = RealMath.prevFloat(Math.asin(interval.getInf()));
        double asinu = RealMath.nextFloat(Math.asin(interval.getSup()));
        int modSup = (int)Math.floor((res.getInf() + RealMath.nextFloat(Math.PI)) / RealMath.prevFloat(Math.PI * 2));
        if (modSup < 0) {
            decSup = RealMath.nextFloat((double)(2 * modSup) * RealMath.prevFloat(Math.PI));
            decInf = RealMath.prevFloat((double)(2 * modSup) * RealMath.nextFloat(Math.PI));
        } else if (modSup > 0) {
            decSup = RealMath.nextFloat((double)(2 * modSup) * RealMath.nextFloat(Math.PI));
            decInf = RealMath.prevFloat((double)(2 * modSup) * RealMath.prevFloat(Math.PI));
        } else {
            decSup = 0.0;
            decInf = 0.0;
        }
        if (interval.getInf() > -1.0) {
            if (res.getInf() > RealMath.nextFloat(RealMath.nextFloat(-Math.PI) - asinl + decSup) && res.getInf() < RealMath.prevFloat(asinl + decInf)) {
                retInf = RealMath.prevFloat(asinl + decInf);
            }
            if (res.getInf() > RealMath.nextFloat(RealMath.nextFloat(Math.PI) - asinl + decSup) && res.getInf() < RealMath.prevFloat(asinl + 2.0 * RealMath.prevFloat(Math.PI) + decInf)) {
                retInf = RealMath.prevFloat(asinl + 2.0 * RealMath.prevFloat(Math.PI) + decInf);
            }
        }
        if (interval.getSup() < 1.0 && res.getInf() > asinu + decSup && res.getInf() < RealMath.prevFloat(RealMath.prevFloat(Math.PI) - asinu) + decInf) {
            retInf = RealMath.prevFloat(RealMath.prevFloat(Math.PI) - asinu) + decInf;
        }
        if ((modSup = (int)Math.floor((res.getSup() + RealMath.nextFloat(Math.PI)) / RealMath.prevFloat(Math.PI * 2))) < 0) {
            decSup = RealMath.nextFloat((double)(2 * modSup) * RealMath.prevFloat(Math.PI));
            decInf = RealMath.prevFloat((double)(2 * modSup) * RealMath.nextFloat(Math.PI));
        } else if (modSup > 0) {
            decSup = RealMath.nextFloat((double)(2 * modSup) * RealMath.nextFloat(Math.PI));
            decInf = RealMath.prevFloat((double)(2 * modSup) * RealMath.prevFloat(Math.PI));
        } else {
            decSup = 0.0;
            decInf = 0.0;
        }
        if (interval.getInf() > -1.0) {
            if (res.getSup() > RealMath.nextFloat(RealMath.nextFloat(-Math.PI) - asinl + decSup) && res.getSup() < RealMath.prevFloat(asinl + decInf)) {
                retSup = RealMath.nextFloat(RealMath.nextFloat(-Math.PI) - asinl + decSup);
            }
            if (res.getSup() > RealMath.nextFloat(RealMath.nextFloat(Math.PI) - asinl + decSup) && res.getSup() < RealMath.prevFloat(asinl + 2.0 * RealMath.prevFloat(Math.PI) + decInf)) {
                retSup = RealMath.nextFloat(RealMath.nextFloat(Math.PI) - asinl + decSup);
            }
        }
        if (interval.getSup() < 1.0 && res.getSup() > asinu + decSup && res.getSup() < RealMath.prevFloat(RealMath.prevFloat(Math.PI) - asinu) + decInf) {
            retSup = asinu + decSup;
        }
        return new RealIntervalConstant(retInf, retSup);
    }

    public static RealInterval acos_wrt(RealInterval interval, RealInterval res) {
        double decInf;
        double decSup;
        double retSup = Double.POSITIVE_INFINITY;
        double retInf = Double.NEGATIVE_INFINITY;
        double acosl = RealMath.prevFloat(Math.acos(interval.getSup()));
        double acosu = RealMath.nextFloat(Math.acos(interval.getInf()));
        int modSup = (int)Math.floor(res.getInf() / RealMath.prevFloat(Math.PI * 2));
        if (modSup < 0) {
            decSup = RealMath.nextFloat((double)(2 * modSup) * RealMath.prevFloat(Math.PI));
            decInf = RealMath.prevFloat((double)(2 * modSup) * RealMath.nextFloat(Math.PI));
        } else if (modSup > 0) {
            decSup = RealMath.nextFloat((double)(2 * modSup) * RealMath.nextFloat(Math.PI));
            decInf = RealMath.prevFloat((double)(2 * modSup) * RealMath.prevFloat(Math.PI));
        } else {
            decSup = 0.0;
            decInf = 0.0;
        }
        if (interval.getSup() < 1.0) {
            if (res.getInf() > RealMath.nextFloat(decSup - acosl) && res.getInf() < RealMath.prevFloat(decInf + acosl)) {
                retInf = RealMath.prevFloat(decInf + acosl);
            }
            if (res.getInf() > RealMath.nextFloat(2.0 * RealMath.nextFloat(Math.PI) - acosl + decSup) && res.getInf() < RealMath.prevFloat(2.0 * RealMath.prevFloat(Math.PI) + acosl + decInf)) {
                retInf = RealMath.prevFloat(2.0 * RealMath.prevFloat(Math.PI) + acosl + decInf);
            }
        }
        if (interval.getInf() > -1.0 && res.getInf() > RealMath.nextFloat(acosu + decSup) && res.getInf() < RealMath.prevFloat(2.0 * RealMath.prevFloat(Math.PI) - acosu + decInf)) {
            retInf = RealMath.prevFloat(2.0 * RealMath.prevFloat(Math.PI) - acosu + decInf);
        }
        if ((modSup = (int)Math.floor(res.getSup() / RealMath.prevFloat(Math.PI * 2))) < 0) {
            decSup = RealMath.nextFloat((double)(2 * modSup) * RealMath.prevFloat(Math.PI));
            decInf = RealMath.prevFloat((double)(2 * modSup) * RealMath.nextFloat(Math.PI));
        } else if (modSup > 0) {
            decSup = RealMath.nextFloat((double)(2 * modSup) * RealMath.nextFloat(Math.PI));
            decInf = RealMath.prevFloat((double)(2 * modSup) * RealMath.prevFloat(Math.PI));
        } else {
            decSup = 0.0;
            decInf = 0.0;
        }
        if (interval.getSup() < 1.0) {
            if (res.getSup() > RealMath.nextFloat(decSup - acosl) && res.getSup() < RealMath.prevFloat(decInf + acosl)) {
                retSup = RealMath.nextFloat(decSup - acosl);
            }
            if (res.getSup() > RealMath.nextFloat(2.0 * RealMath.nextFloat(Math.PI) - acosl + decSup) && res.getSup() < RealMath.prevFloat(2.0 * RealMath.prevFloat(Math.PI) + acosl + decInf)) {
                retSup = RealMath.nextFloat(2.0 * RealMath.nextFloat(Math.PI) - acosl + decSup);
            }
        }
        if (interval.getInf() > -1.0 && res.getSup() > RealMath.nextFloat(acosu + decSup) && res.getSup() < RealMath.prevFloat(2.0 * RealMath.prevFloat(Math.PI) - acosu + decInf)) {
            retSup = RealMath.nextFloat(acosu + decSup);
        }
        return new RealIntervalConstant(retInf, retSup);
    }
}

