/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.arithm;

import choco.cp.solver.constraints.integer.TimesXYZ;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.ArithmNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class MultNode
extends INode
implements ArithmNode {
    public MultNode(INode[] subt) {
        super(subt, NodeType.MULT);
    }

    @Override
    public int eval(int[] tuple) {
        return ((ArithmNode)((Object)this.subtrees[0])).eval(tuple) * ((ArithmNode)((Object)this.subtrees[1])).eval(tuple);
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar v1 = this.subtrees[0].extractResult(s);
        IntDomainVar v2 = this.subtrees[1].extractResult(s);
        long i1 = v1.getInf();
        long s1 = v1.getSup();
        long i2 = v2.getInf();
        long s2 = v2.getSup();
        long a = i1 * i2;
        long b = i1 * s2;
        long c = s1 * i2;
        long d = s1 * s2;
        long _lb = Math.min(Math.min(Math.min(a, b), c), d);
        long _ub = Math.max(Math.max(Math.max(a, b), c), d);
        int lb = (int)Math.max(_lb, Integer.MIN_VALUE);
        int ub = (int)Math.min(_ub, Integer.MAX_VALUE);
        IntDomainVar v3 = lb == 0 && ub == 1 ? s.createBooleanVar(StringUtils.randomName()) : (v1.hasEnumeratedDomain() && v2.hasEnumeratedDomain() ? s.createEnumIntVar(StringUtils.randomName(), lb, ub) : s.createBoundIntVar(StringUtils.randomName(), lb, ub));
        s.post(new TimesXYZ(v1, v2, v3));
        return v3;
    }

    @Override
    public String pretty() {
        return "(" + this.subtrees[0].pretty() + " * " + this.subtrees[1].pretty() + ")";
    }

    @Override
    public boolean isALinearTerm() {
        int a = this.subtrees[0].countNbVar();
        int b = this.subtrees[1].countNbVar();
        return (a == 0 || b == 0) && this.subtrees[0].isALinearTerm() && this.subtrees[1].isALinearTerm();
    }

    @Override
    public int[] computeLinearExpr(int scope) {
        int[] coeffs = this.subtrees[0].computeLinearExpr(scope);
        int[] coeffs2 = this.subtrees[1].computeLinearExpr(scope);
        if (this.subtrees[0].isAConstant()) {
            for (int i = 0; i < scope + 1; ++i) {
                coeffs[i] = coeffs2[i] * coeffs[scope];
            }
        } else if (this.subtrees[1].isAConstant()) {
            for (int i = 0; i < scope + 1; ++i) {
                coeffs[i] = coeffs[i] * coeffs2[scope];
            }
        } else {
            for (int i = 0; i < scope + 1; ++i) {
                if (coeffs[i] == 0) {
                    coeffs[i] = coeffs2[i];
                    continue;
                }
                if (coeffs2[i] == 0) continue;
                coeffs[i] = coeffs2[i] * coeffs[i];
            }
        }
        return coeffs;
    }
}

