/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.intlincomb.policy;

import choco.cp.solver.constraints.integer.intlincomb.policy.ForScalar;
import choco.cp.solver.constraints.integer.intlincomb.policy.ForSum;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class CoeffPolicy {
    final IntDomainVar[] vars;
    final int cste;
    final int nbPosVars;
    final int[] coeffs;

    public static CoeffPolicy build(IntDomainVar[] vars, int[] coeffs, int nbPosVars, int cste) {
        if (CoeffPolicy.isIntSum(coeffs, nbPosVars)) {
            return ForSum.get(vars, coeffs, nbPosVars, cste);
        }
        return ForScalar.get(vars, coeffs, nbPosVars, cste);
    }

    private static boolean isIntSum(int[] sortedCoeffs, int nbPositiveCoeffs) {
        int i;
        for (i = 0; i < nbPositiveCoeffs; ++i) {
            if (sortedCoeffs[i] == 1) continue;
            return false;
        }
        for (i = nbPositiveCoeffs; i < sortedCoeffs.length; ++i) {
            if (sortedCoeffs[i] == -1) continue;
            return false;
        }
        return true;
    }

    CoeffPolicy(IntDomainVar[] vars, int[] coeffs, int nbPosVars, int cste) {
        this.vars = vars;
        this.coeffs = coeffs;
        this.nbPosVars = nbPosVars;
        this.cste = cste;
    }

    public abstract int getInfNV(int var1, int var2);

    public abstract int getSupNV(int var1, int var2);

    public abstract int getInfPV(int var1, int var2);

    public abstract int getSupPV(int var1, int var2);

    public abstract int computeUpperBound();

    public abstract int computeLowerBound();
}

