/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.CspBinSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class AC3BinSConstraint
extends CspBinSConstraint {
    public AC3BinSConstraint(IntDomainVar x0, IntDomainVar x1, BinRelation rela) {
        super(x0, x1, rela);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 12;
    }

    @Override
    public Object clone() {
        return new AC3BinSConstraint(this.v0, this.v1, this.relation);
    }

    public void reviseV1() throws ContradictionException {
        int left;
        int nbs = 0;
        int right = left = Integer.MIN_VALUE;
        DisposableIntIterator itv1 = this.v1.getDomain().getIterator();
        while (itv1.hasNext()) {
            int val1 = itv1.next();
            DisposableIntIterator itv0 = this.v0.getDomain().getIterator();
            while (itv0.hasNext()) {
                int val0 = itv0.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                ++nbs;
                break;
            }
            itv0.dispose();
            if (nbs == 0) {
                if (val1 == right + 1) {
                    right = val1;
                } else {
                    this.v1.removeInterval(left, right, this, false);
                    left = right = val1;
                }
            }
            nbs = 0;
        }
        this.v1.removeInterval(left, right, this, false);
        itv1.dispose();
    }

    public void reviseV0() throws ContradictionException {
        int left;
        int nbs = 0;
        int right = left = Integer.MIN_VALUE;
        DisposableIntIterator itv0 = this.v0.getDomain().getIterator();
        while (itv0.hasNext()) {
            int val0 = itv0.next();
            DisposableIntIterator itv1 = this.v1.getDomain().getIterator();
            while (itv1.hasNext()) {
                int val1 = itv1.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                ++nbs;
                break;
            }
            itv1.dispose();
            if (nbs == 0) {
                if (val0 == right + 1) {
                    right = val0;
                } else {
                    this.v0.removeInterval(left, right, this, false);
                    left = right = val0;
                }
            }
            nbs = 0;
        }
        this.v0.removeInterval(left, right, this, false);
        itv0.dispose();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.reviseV0();
        this.reviseV1();
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        BinRelation rela2 = (BinRelation)((Object)((ConsistencyRelation)((Object)this.relation)).getOpposite());
        AC3BinSConstraint ct = new AC3BinSConstraint(this.v0, this.v1, rela2);
        return ct;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("AC3(").append(this.v0.pretty()).append(", ").append(this.v1.pretty()).append(", ").append(this.relation.getClass().getSimpleName()).append(")");
        return sb.toString();
    }
}

