/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.set;

import choco.kernel.model.IConstraintList;
import choco.kernel.model.variables.ComponentVariable;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.set.SetExpressionVariable;

public class SetVariable
extends SetExpressionVariable {
    protected int[] values;
    protected IntegerVariable card;

    protected SetVariable(VariableType variableType, boolean enableOption, int[] parameter, IConstraintList constraints, IntegerVariable card) {
        super(variableType, enableOption, (Object)new Object[]{parameter, card}, constraints);
        this.card = card;
        if (parameter.length > 0) {
            this.lowB = parameter[0];
            this.uppB = parameter[parameter.length - 1];
        }
        this.setVariables(this);
    }

    public SetVariable(String name, int lowB, int uppB, IntegerVariable card) {
        this(VariableType.SET, true, new int[]{lowB, uppB}, new ComponentVariable.ConstraintsDataStructure(), card);
        this.setName(name);
    }

    public SetVariable(String name, int[] values, IntegerVariable card) {
        this(VariableType.SET, true, values, new ComponentVariable.ConstraintsDataStructure(), card);
        this.setName(name);
        this.values = values;
    }

    public final IntegerVariable getCard() {
        return this.card;
    }

    public final void setCard(IntegerVariable card) {
        this.card = card;
    }

    public int[] getValues() {
        return this.values;
    }

    @Override
    public String pretty() {
        return this.name + " [" + this.getLowB() + ", " + this.getUppB() + "]";
    }

    @Override
    public void addOption(String options) {
        super.addOption(options);
        this.card.addOption(options);
    }

    @Override
    public Variable[] doExtractVariables() {
        return this.getVariables();
    }
}

