/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.real.objective;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solution;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.search.IObjectiveManager;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.real.RealIntervalConstant;
import choco.kernel.solver.variables.real.RealVar;

public abstract class RealObjectiveManager
implements IObjectiveManager {
    public final RealVar objective;
    protected RealIntervalConstant boundInterval;
    protected double bound;
    protected double floorBound;
    protected double targetBound;

    public RealObjectiveManager(RealVar objective) {
        this.objective = objective;
    }

    public abstract double getInitialBoundValue();

    public abstract double getFloorValue();

    public abstract double getCeilValue();

    @Override
    public final Var getObjective() {
        return this.objective;
    }

    @Override
    public final Number getObjectiveValue() {
        return this.getFloorValue();
    }

    @Override
    public final Number getBestObjectiveValue() {
        return this.bound;
    }

    @Override
    public final Number getObjectiveTarget() {
        return this.targetBound;
    }

    @Override
    public final Number getObjectiveFloor() {
        return this.floorBound;
    }

    @Override
    public final void initBounds() {
        this.bound = this.getInitialBoundValue();
        this.floorBound = this.getFloorValue();
        this.targetBound = this.getCeilValue();
        this.setBoundInterval();
    }

    protected abstract void setBoundInterval();

    @Override
    public final void postTargetBound() throws ContradictionException {
        this.objective.intersect(this.boundInterval);
    }

    @Override
    public final void postFloorBound() throws ContradictionException {
        throw new SolverException("not yet implemented");
    }

    @Override
    public final void postIncFloorBound() throws ContradictionException {
        throw new SolverException("not yet implemented");
    }

    @Override
    public final void incrementFloorBound() {
        throw new SolverException("not yet implemented");
    }

    @Override
    public final void writeObjective(Solution sol) {
        sol.recordRealObjective(this.getFloorValue());
    }
}

