/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.varselector.ratioselector;

import choco.cp.solver.search.integer.varselector.ratioselector.IntVarRatioSelector;
import choco.cp.solver.search.integer.varselector.ratioselector.ratios.IntRatio;
import choco.cp.solver.search.integer.varselector.ratioselector.ratios.SimpleRatio;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.Solver;
import choco.kernel.solver.search.AbstractSearchHeuristic;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public abstract class AbstractIntVarRatioSelector
extends AbstractSearchHeuristic
implements IntVarRatioSelector {
    protected final IntRatio[] ratios;
    private final IStateInt begin;
    private final SimpleRatio bestRatio = new SimpleRatio();
    private int reuseIdx;

    public AbstractIntVarRatioSelector(Solver solver, IntRatio[] ratios) {
        super(solver);
        this.ratios = ratios;
        this.begin = solver.getEnvironment().makeInt(0);
    }

    @Override
    public final IntRatio[] getRatios() {
        return this.ratios;
    }

    private long getLeftMember(int idx) {
        return this.bestRatio.getLeftMember(this.ratios[idx]);
    }

    private long getRightMember(int idx) {
        return this.bestRatio.getRightMember(this.ratios[idx]);
    }

    protected abstract boolean isUp(long var1, long var3);

    private void initialize() {
        this.reuseIdx = this.begin.get();
        while (this.reuseIdx < this.ratios.length && !this.ratios[this.reuseIdx].isActive()) {
            ++this.reuseIdx;
        }
        this.begin.set(this.reuseIdx);
    }

    protected final int selectRandIntRatioIndex(Random randomBreakTies, TIntArrayList canWriteList) {
        this.initialize();
        if (this.reuseIdx < this.ratios.length) {
            canWriteList.resetQuick();
            canWriteList.add(this.reuseIdx);
            this.bestRatio.setRatio(this.ratios[this.reuseIdx]);
            ++this.reuseIdx;
            while (this.reuseIdx < this.ratios.length) {
                if (this.ratios[this.reuseIdx].isActive()) {
                    long rightM;
                    long leftM = this.getLeftMember(this.reuseIdx);
                    if (this.isUp(leftM, rightM = this.getRightMember(this.reuseIdx))) {
                        canWriteList.resetQuick();
                        canWriteList.add(this.reuseIdx);
                        this.bestRatio.setRatio(this.ratios[this.reuseIdx]);
                    } else if (leftM == rightM) {
                        canWriteList.add(this.reuseIdx);
                    }
                }
                ++this.reuseIdx;
            }
            int n = canWriteList.size();
            switch (canWriteList.size()) {
                case 1: {
                    return canWriteList.get(0);
                }
            }
            return canWriteList.get(randomBreakTies.nextInt(n));
        }
        return -1;
    }

    @Override
    public int selectIntRatioIndex() {
        this.initialize();
        int bestIdx = -1;
        if (this.reuseIdx < this.ratios.length) {
            bestIdx = this.reuseIdx;
            this.bestRatio.setRatio(this.ratios[this.reuseIdx]);
            ++this.reuseIdx;
            while (this.reuseIdx < this.ratios.length) {
                if (this.ratios[this.reuseIdx].isActive() && this.isUp(this.getLeftMember(this.reuseIdx), this.getRightMember(this.reuseIdx))) {
                    bestIdx = this.reuseIdx;
                    this.bestRatio.setRatio(this.ratios[this.reuseIdx]);
                }
                ++this.reuseIdx;
            }
        }
        return bestIdx;
    }

    @Override
    public final IntRatio selectIntRatio() {
        int bestIdx = this.selectIntRatioIndex();
        return bestIdx >= 0 ? this.ratios[bestIdx] : null;
    }

    @Override
    public final IntDomainVar selectVar() {
        int bestIdx = this.selectIntRatioIndex();
        return bestIdx >= 0 ? this.ratios[bestIdx].getIntVar() : null;
    }

    public final List<IntDomainVar> selectTiedIntVars() {
        this.initialize();
        LinkedList<IntDomainVar> vars = new LinkedList<IntDomainVar>();
        if (this.reuseIdx < this.ratios.length) {
            vars.add(this.ratios[this.reuseIdx].getIntVar());
            this.bestRatio.setRatio(this.ratios[this.reuseIdx]);
            ++this.reuseIdx;
            while (this.reuseIdx < this.ratios.length) {
                if (this.ratios[this.reuseIdx].isActive()) {
                    long rightM;
                    long leftM = this.getLeftMember(this.reuseIdx);
                    if (this.isUp(leftM, rightM = this.getRightMember(this.reuseIdx))) {
                        vars.clear();
                        this.bestRatio.setRatio(this.ratios[this.reuseIdx]);
                        vars.add(this.ratios[this.reuseIdx].getIntVar());
                    } else if (leftM == rightM) {
                        vars.add(this.ratios[this.reuseIdx].getIntVar());
                    }
                }
                ++this.reuseIdx;
            }
        }
        return vars;
    }
}

