/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.pack;

import choco.cp.solver.constraints.global.pack.IPackSConstraint;
import choco.cp.solver.constraints.global.pack.PackFiltering;
import choco.kernel.common.opres.nosum.NoSumList;
import choco.kernel.common.opres.pack.LowerBoundFactory;
import choco.kernel.common.util.bitmask.BitMask;
import choco.kernel.common.util.bitmask.StringMask;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.set.AbstractLargeSetIntSConstraint;
import choco.kernel.solver.search.ISolutionDisplay;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.Arrays;
import java.util.List;

public class PackSConstraint
extends AbstractLargeSetIntSConstraint
implements IPackSConstraint,
ISolutionDisplay {
    public static final StringMask ADDITIONAL_RULES = new StringMask("cp:pack:additional_rules", 1L);
    public static final StringMask DYNAMIC_LB = new StringMask("cp:pack:dynamic_lower_bound", 4L);
    public static final StringMask FILL_BIN = new StringMask("cp:pack:fill_bins", 8L);
    public static final StringMask LAST_BINS_EMPTY = new StringMask("cp:pack:last_bins_empty", 16L);
    public final BitMask flags = new BitMask();
    public final PackFiltering filtering;
    protected final BoundNumberOfBins bounds;
    private final NoSumList reuseStatus;
    private IStateIntVector availableBins;
    protected final int[] sizes;
    protected final IntDomainVar[] loads;
    protected final IntDomainVar[] bins;

    public PackSConstraint(IEnvironment environment, SetVar[] itemSets, IntDomainVar[] loads, IntDomainVar[] sizes, IntDomainVar[] bins, IntDomainVar nbNonEmpty) {
        super(ArrayUtils.append(loads, sizes, bins, {nbNonEmpty}), itemSets);
        this.loads = loads;
        this.sizes = VariableUtils.getConstantValues(sizes);
        this.bins = bins;
        this.bounds = new BoundNumberOfBins();
        this.filtering = new PackFiltering(this, this.flags);
        this.availableBins = environment.makeBipartiteIntList(ArrayUtils.zeroToN(this.getNbBins()));
        this.reuseStatus = new NoSumList(this.sizes);
    }

    public void readOptions(List<String> options) {
        this.flags.read(options, ADDITIONAL_RULES, DYNAMIC_LB, FILL_BIN, LAST_BINS_EMPTY);
    }

    public final boolean isEmpty(int bin) {
        return this.svars[bin].getKernelDomainSize() == 0;
    }

    @Override
    public void fireAvailableBins() {
        DisposableIntIterator iter = this.availableBins.getIterator();
        while (iter.hasNext()) {
            int b = iter.next();
            if (!this.svars[b].isInstantiated()) continue;
            iter.remove();
        }
        iter.dispose();
    }

    @Override
    public final IStateIntVector getAvailableBins() {
        return this.availableBins;
    }

    public final int getRequiredSpace(int bin) {
        DisposableIntIterator iter = this.svars[bin].getDomain().getKernelIterator();
        int load = 0;
        while (iter.hasNext()) {
            load += this.sizes[iter.next()];
        }
        iter.dispose();
        return load;
    }

    public final int getRemainingSpace(int bin) {
        return this.loads[bin].getSup() - this.getRequiredSpace(bin);
    }

    protected final boolean isSetEvent(int varIdx) {
        return varIdx < this.svars.length;
    }

    protected final boolean isItemEvent(int varIdx) {
        int a = 2 * this.getNbBins() + this.getNbItems();
        int b = a + this.getNbItems();
        return varIdx >= a && varIdx < b;
    }

    protected final int getItemIndex(int varIdx) {
        return varIdx - 2 * this.getNbBins() - this.getNbItems();
    }

    @Override
    public final IntDomainVar[] getBins() {
        return this.bins;
    }

    @Override
    public final int getNbBins() {
        return this.svars.length;
    }

    @Override
    public final int getNbItems() {
        return this.sizes.length;
    }

    @Override
    public final IntDomainVar[] getLoads() {
        return this.loads;
    }

    @Override
    public final int[] getSizes() {
        return this.sizes;
    }

    @Override
    public final NoSumList getStatus(int bin) {
        this.reuseStatus.setCandidatesFromVar(this.svars[bin]);
        return this.reuseStatus;
    }

    @Override
    public final boolean pack(int item, int bin) throws ContradictionException {
        boolean res = this.svars[bin].addToKernel(item, this, false);
        if (this.bins[item].canBeInstantiatedTo(bin)) {
            DisposableIntIterator iter = this.bins[item].getDomain().getIterator();
            while (iter.hasNext()) {
                int b = iter.next();
                if (b == bin) continue;
                res |= this.svars[b].remFromEnveloppe(item, this, false);
            }
            res |= this.bins[item].instantiate(bin, this, false);
        } else {
            this.fail();
        }
        return res;
    }

    @Override
    public final boolean remove(int item, int bin) throws ContradictionException {
        boolean res = this.svars[bin].remFromEnveloppe(item, this, false);
        res |= this.bins[item].removeVal(bin, this, false);
        if (this.bins[item].isInstantiated()) {
            int b = this.bins[item].getVal();
            this.svars[b].addToKernel(item, this, false);
        }
        return res;
    }

    @Override
    public final boolean updateInfLoad(int bin, int load) throws ContradictionException {
        return this.loads[bin].updateInf(load, this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean updateNbNonEmpty(int min, int max) throws ContradictionException {
        boolean res = false;
        int idx = this.ivars.length - 1;
        this.ivars[idx].updateInf(min, this, false);
        int oldSup = this.ivars[idx].getSup();
        if (this.ivars[idx].updateSup(max, this, false) && this.flags.contains(LAST_BINS_EMPTY)) {
            for (int b = max; b < oldSup; ++b) {
                DisposableIntIterator iter = this.svars[b].getDomain().getEnveloppeIterator();
                try {
                    while (iter.hasNext()) {
                        res |= this.remove(iter.next(), b);
                    }
                    continue;
                }
                finally {
                    iter.dispose();
                }
            }
        }
        return res;
    }

    @Override
    public final boolean updateSupLoad(int bin, int load) throws ContradictionException {
        return this.loads[bin].updateSup(load, this, false);
    }

    @Override
    public boolean isConsistent() {
        return false;
    }

    protected final void checkBounds(int item) throws ContradictionException {
        this.bins[item].updateInf(0, this, false);
        this.bins[item].updateSup(this.svars.length - 1, this, false);
    }

    protected final void checkEnveloppes() throws ContradictionException {
        for (int bin = 0; bin < this.svars.length; ++bin) {
            int sup;
            int inf;
            while ((inf = this.svars[bin].getEnveloppeInf()) < 0 && this.svars[bin].remFromEnveloppe(inf, this, false)) {
            }
            while ((sup = this.svars[bin].getEnveloppeSup()) > this.bins.length - 1 && this.svars[bin].remFromEnveloppe(sup, this, false)) {
            }
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.checkEnveloppes();
        for (int item = 0; item < this.bins.length; ++item) {
            this.checkBounds(item);
            if (this.bins[item].isInstantiated()) {
                int b;
                int b0 = this.bins[item].getVal();
                this.svars[b0].addToKernel(item, this, false);
                for (b = 0; b < b0; ++b) {
                    this.svars[b].remFromEnveloppe(item, this, false);
                }
                for (b = b0 + 1; b < this.svars.length; ++b) {
                    this.svars[b].remFromEnveloppe(item, this, false);
                }
                continue;
            }
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            for (int bin = 0; bin < this.svars.length; ++bin) {
                if (this.svars[bin].isInDomainEnveloppe(item)) {
                    if (this.svars[bin].isInDomainKernel(item)) {
                        this.bins[item].instantiate(bin, this, false);
                        continue;
                    }
                    if (this.bins[item].canBeInstantiatedTo(bin)) continue;
                    this.svars[bin].remFromEnveloppe(item, this, false);
                    continue;
                }
                if (bin == right + 1) {
                    right = bin;
                    continue;
                }
                this.bins[item].removeInterval(left, right, this, false);
                left = right = bin;
            }
            this.bins[item].removeInterval(left, right, this, false);
        }
        super.awake();
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        this.bins[x].removeVal(varIdx, this, false);
        if (this.bins[x].isInstantiated()) {
            int b = this.bins[x].getVal();
            this.svars[b].addToKernel(x, this, false);
        }
        this.constAwake(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDeltaDomain(int item) throws ContradictionException {
        DisposableIntIterator iter = this.bins[item].getDomain().getDeltaIterator();
        if (iter.hasNext()) {
            try {
                while (iter.hasNext()) {
                    int b = iter.next();
                    this.svars[b].remFromEnveloppe(item, this, false);
                }
            }
            finally {
                iter.dispose();
            }
        } else {
            throw new SolverException("empty delta domain: " + this.bins[item].pretty());
        }
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        if (this.isItemEvent(varIndex)) {
            int item = this.getItemIndex(varIndex);
            this.checkDeltaDomain(item);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        this.awakeOnBounds(varIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        if (this.isSetEvent(varIdx)) {
            int item;
            DisposableIntIterator iter = this.svars[varIdx].getDomain().getKernelIterator();
            try {
                while (iter.hasNext()) {
                    item = iter.next();
                    if (this.bins[item].isInstantiated()) continue;
                    this.pack(item, varIdx);
                }
            }
            finally {
                iter.dispose();
            }
            iter = this.svars[varIdx].getDomain().getEnveloppeDomain().getDeltaIterator();
            try {
                while (iter.hasNext()) {
                    item = iter.next();
                    if (!this.bins[item].canBeInstantiatedTo(varIdx)) continue;
                    this.remove(item, varIdx);
                }
            }
            finally {
                iter.dispose();
            }
        }
        if (this.isItemEvent(varIdx)) {
            int item = this.getItemIndex(varIdx);
            int b = this.bins[item].getVal();
            this.svars[b].addToKernel(item, this, false);
            this.checkDeltaDomain(item);
        } else {
            this.handleNbBinsEvent(varIdx);
        }
        this.constAwake(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNbBinsEvent(int varIdx) throws ContradictionException {
        if (varIdx == this.getNbVars() - 1 && this.flags.contains(LAST_BINS_EMPTY)) {
            for (int b = this.ivars[this.ivars.length - 1].getSup(); b < this.getNbBins(); ++b) {
                DisposableIntIterator iter = this.svars[b].getDomain().getEnveloppeIterator();
                try {
                    while (iter.hasNext()) {
                        this.remove(iter.next(), b);
                    }
                    continue;
                }
                finally {
                    iter.dispose();
                }
            }
        }
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        this.pack(x, varIdx);
        this.constAwake(false);
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
        if (this.isItemEvent(varIdx)) {
            this.svars[val].remFromEnveloppe(this.getItemIndex(varIdx), this, false);
        }
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        this.handleNbBinsEvent(varIdx);
        this.awakeOnBounds(varIdx);
    }

    @Override
    public void propagate() throws ContradictionException {
        do {
            this.filtering.propagate();
            if (this.bounds.computeBounds(this.flags.contains(DYNAMIC_LB))) continue;
            this.fail();
        } while (this.updateNbNonEmpty(this.bounds.getMinimumNumberOfBins(), this.bounds.getMaximumNumberOfBins()));
    }

    @Override
    public boolean isSatisfied() {
        int[] l = new int[this.loads.length];
        int[] c = new int[this.loads.length];
        for (int i = 0; i < this.bins.length; ++i) {
            int b = this.bins[i].getVal();
            if (!this.svars[b].isInDomainKernel(i)) {
                return false;
            }
            int n = b;
            l[n] = l[n] + this.sizes[i];
            int n2 = b;
            c[n2] = c[n2] + 1;
        }
        int nbb = 0;
        for (int i = 0; i < this.loads.length; ++i) {
            if (this.svars[i].getCard().getVal() != c[i]) {
                return false;
            }
            if (this.loads[i].getVal() != l[i]) {
                return false;
            }
            if (c[i] == 0) continue;
            ++nbb;
        }
        return this.ivars[this.ivars.length - 1].getVal() == nbb;
    }

    @Override
    public final String solutionToString() {
        StringBuilder b = new StringBuilder();
        for (SetVar s : this.svars) {
            int[] t = s.getValue();
            if (t == null || t.length <= 0) continue;
            int l = t.length - 1;
            b.append('[');
            for (int i = 0; i < l; ++i) {
                b.append(this.sizes[t[i]]).append(", ");
            }
            b.append(this.sizes[t[l]]).append("] ");
        }
        return b.toString();
    }

    protected final class BoundNumberOfBins {
        private final int[] remainingSpace;
        private final TIntArrayList itemsMLB;
        protected int capacityMLB;
        private final TIntArrayList binsMLB;
        private int sizeIMLB;
        private int totalSizeCLB;
        private final TIntArrayList binsCLB;
        protected int nbEmpty;
        protected int nbSome;
        protected int nbFull;
        protected int nbNewCLB;
        private final TIntProcedure minimumNumberOfNewBins = new TIntProcedure(){

            @Override
            public boolean execute(int arg0) {
                ++BoundNumberOfBins.this.nbNewCLB;
                if (BoundNumberOfBins.this.totalSizeCLB <= arg0) {
                    return false;
                }
                BoundNumberOfBins.this.totalSizeCLB -= arg0;
                return true;
            }
        };

        public BoundNumberOfBins() {
            this.itemsMLB = new TIntArrayList(PackSConstraint.this.getNbBins() + PackSConstraint.this.getNbItems());
            this.binsMLB = new TIntArrayList(PackSConstraint.this.getNbBins());
            this.binsCLB = new TIntArrayList(PackSConstraint.this.getNbBins());
            this.remainingSpace = new int[PackSConstraint.this.getNbBins()];
        }

        public void reset() {
            Arrays.fill(this.remainingSpace, 0);
            this.itemsMLB.resetQuick();
            this.capacityMLB = 0;
            this.binsMLB.resetQuick();
            this.totalSizeCLB = 0;
            this.binsCLB.resetQuick();
            this.nbEmpty = 0;
            this.nbSome = 0;
            this.nbFull = 0;
            this.nbNewCLB = 0;
        }

        private void handleItems() {
            int n = PackSConstraint.this.getNbItems();
            for (int i = 0; i < n; ++i) {
                int size = PackSConstraint.this.sizes[i];
                if (PackSConstraint.this.bins[i].isInstantiated()) {
                    int n2 = PackSConstraint.this.bins[i].getVal();
                    this.remainingSpace[n2] = this.remainingSpace[n2] - PackSConstraint.this.sizes[i];
                    continue;
                }
                this.totalSizeCLB += PackSConstraint.this.sizes[i];
                this.itemsMLB.add(PackSConstraint.this.sizes[i]);
            }
            this.sizeIMLB = this.itemsMLB.size();
        }

        private void handleBins() {
            int n = PackSConstraint.this.getNbBins();
            for (int b = 0; b < n; ++b) {
                if (PackSConstraint.this.svars[b].isInstantiated()) {
                    if (PackSConstraint.this.loads[b].isInstantiatedTo(0)) {
                        ++this.nbEmpty;
                        continue;
                    }
                    ++this.nbFull;
                    continue;
                }
                this.binsMLB.add(b);
                int n2 = b;
                this.remainingSpace[n2] = this.remainingSpace[n2] + PackSConstraint.this.loads[b].getSup();
                this.capacityMLB = Math.max(this.capacityMLB, this.remainingSpace[b]);
                if (PackSConstraint.this.svars[b].getKernelDomainSize() > 0) {
                    ++this.nbSome;
                    this.totalSizeCLB -= this.remainingSpace[b];
                    continue;
                }
                this.binsCLB.add(this.remainingSpace[b]);
            }
        }

        private void createFakeItems() {
            int n = this.binsMLB.size();
            for (int i = 0; i < n; ++i) {
                int size = this.capacityMLB - this.remainingSpace[this.binsMLB.getQuick(i)];
                if (size <= 0) continue;
                this.itemsMLB.add(size);
            }
        }

        private void computeMinimumNumberOfNewBins() {
            this.binsCLB.sort();
            this.binsCLB.forEachDescending(this.minimumNumberOfNewBins);
        }

        public boolean computeBounds(boolean useMDFF) {
            this.reset();
            this.handleItems();
            this.handleBins();
            if (!this.itemsMLB.isEmpty()) {
                if (this.totalSizeCLB > 0) {
                    if (this.binsCLB.isEmpty()) {
                        return false;
                    }
                    this.computeMinimumNumberOfNewBins();
                }
                if (this.getMinimumNumberOfBins() > PackSConstraint.this.ivars[PackSConstraint.this.ivars.length - 1].getSup()) {
                    return false;
                }
                if (useMDFF) {
                    this.createFakeItems();
                    return LowerBoundFactory.testPackingConsistencyWithMDFF(this.itemsMLB, this.capacityMLB, this.binsMLB.size());
                }
            }
            return true;
        }

        public int getMaximumNumberOfBins() {
            return Math.min(PackSConstraint.this.getNbBins() - this.nbEmpty, this.nbFull + this.nbSome + this.sizeIMLB);
        }

        public int getMinimumNumberOfBins() {
            return this.nbFull + this.nbSome + this.nbNewCLB;
        }
    }
}

