/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.Choco;
import choco.cp.common.util.preprocessor.detector.scheduling.AbstractSchedulingDectector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveModel;
import choco.cp.model.CPModel;
import choco.kernel.model.constraints.TemporalConstraint;
import choco.kernel.model.variables.integer.IntegerVariable;
import java.util.ArrayList;

public class ClauseFromDisjointModelDetector
extends AbstractSchedulingDectector {
    private ArrayList<IntegerVariable> posvars = new ArrayList(2);
    private ArrayList<IntegerVariable> negvars = new ArrayList(2);

    public ClauseFromDisjointModelDetector(CPModel model, DisjunctiveModel disjMod) {
        super(model, disjMod);
    }

    private void clearLits() {
        this.posvars.clear();
        this.negvars.clear();
    }

    private void addPosLit(int o, int d, TemporalConstraint ct) {
        (ct.getOrigin().getHook() == o ? this.posvars : this.negvars).add(ct.getDirection());
    }

    private void addNegLit(int o, int d, TemporalConstraint ct) {
        (ct.getOrigin().getHook() == o ? this.negvars : this.posvars).add(ct.getDirection());
    }

    private void addClause() {
        this.add(Choco.clause(this.posvars.toArray(new IntegerVariable[this.posvars.size()]), this.negvars.toArray(new IntegerVariable[this.negvars.size()])));
        this.clearLits();
    }

    @Override
    public void apply() {
        int n = this.disjMod.getNbNodes();
        for (int k = 0; k < n; ++k) {
            for (int i = 0; i < n; ++i) {
                TemporalConstraint cik;
                if (!this.disjMod.containsEdge(i, k) || !(cik = (TemporalConstraint)this.disjMod.getEdgeConstraint(i, k)).isInPreprocess()) continue;
                for (int j = 0; j < n; ++j) {
                    TemporalConstraint ckj;
                    if (!this.disjMod.containsEdge(k, j) || !(ckj = (TemporalConstraint)this.disjMod.getEdgeConstraint(k, j)).isInPreprocess()) continue;
                    if (this.disjMod.containsEdge(i, j)) {
                        TemporalConstraint cij = (TemporalConstraint)this.disjMod.getEdgeConstraint(i, j);
                        if (!cik.isInPreprocess()) continue;
                        this.addPosLit(i, j, cij);
                        this.addNegLit(i, k, cik);
                        this.addNegLit(k, j, ckj);
                        this.addClause();
                        this.addNegLit(i, j, cij);
                        this.addPosLit(i, k, cik);
                        this.addPosLit(k, j, ckj);
                        this.addClause();
                        continue;
                    }
                    if (this.disjMod.containsArc(i, j)) {
                        this.addPosLit(i, k, cik);
                        this.addPosLit(k, j, ckj);
                        this.addClause();
                        continue;
                    }
                    if (!this.disjMod.containsArc(j, i)) continue;
                    this.addNegLit(i, k, cik);
                    this.addNegLit(k, j, ckj);
                    this.addClause();
                }
            }
        }
    }
}

