/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.kernel.common.util.iterators.ArrayIterator;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.variables.Var;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public class StoredBipartiteSet<E>
extends AbstractList<E> {
    protected E[] elementData;
    protected IStateInt last;

    StoredBipartiteSet(IEnvironment env) {
        this.elementData = new Var[8];
        this.last = env.makeInt(0);
    }

    public StoredBipartiteSet(IEnvironment env, Collection<E> coll) {
        this.elementData = coll.toArray();
        this.last = env.makeInt(this.elementData.length);
    }

    public StoredBipartiteSet(IEnvironment env, E[] elementData) {
        this.elementData = Arrays.copyOf(elementData, elementData.length);
        this.last = env.makeInt(elementData.length);
    }

    void RangeCheck(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    @Override
    public E get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    public E getQuick(int index) {
        return this.elementData[index];
    }

    public DisposableIterator<E> quickIterator() {
        return ArrayIterator.getIterator(this.elementData, this.size());
    }

    @Override
    public int size() {
        return this.last.get();
    }

    @Override
    public E remove(int index) {
        this.RangeCheck(index);
        int idx = this.size() - 1;
        E tmp = this.elementData[index];
        this.elementData[index] = this.elementData[idx];
        this.elementData[idx] = tmp;
        this.last.set(idx);
        return tmp;
    }

    @Override
    public void sort(Comparator<E> cmp) {
        Arrays.sort(this.elementData, 0, this.size(), cmp);
    }
}

