% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/market_fit.R
\name{show,market_model-method}
\alias{show,market_model-method}
\alias{show,market_fit-method}
\title{Prints a short description of the model}
\usage{
\S4method{show}{market_model}(object)

\S4method{show}{market_fit}(object)
}
\arguments{
\item{object}{A model object.}
}
\value{
No return value, called for side effects (print basic model information).
}
\description{
Sends basic information about the model to standard output.
}
\examples{
\donttest{
fit <- equilibrium_model(
  HS | RM | ID | TREND ~
    RM + TREND + W + CSHS + L1RM + L2RM + MONTH |
      RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(),
  estimation_options = list(method = "2SLS")
)

# print model information
show(fit@model)

# print fit information
show(fit)
}
}
