% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nps_calc.R
\name{nps_calc}
\alias{nps_calc}
\title{Tidy Calculation of Net Promoter Score}
\usage{
nps_calc(survey_data, ...)
}
\arguments{
\item{survey_data}{Raw survey data. Needs to be one row per survey with the nps question
in a numeric column called nps_question
responses having column names of needs, ease and emotion}

\item{...}{optional columns by which to group the nps calculation. There is no limit to
the number of grouping variables chosen. Too many will likely result in nps calculations
that are too fragmented / based on very small survey counts.}
}
\value{
Data frame with nps and survey count for each combination of the grouping variables
}
\description{
Simplifies the calculation of Net Promoter Score (NPS) from raw survey data within
the tidyverse framework.
}
\details{
Net Promoter Score was originally developed by Fred Reichheld and now is owned by
Bain Company and Satmetrix Systems. According to Wikipedia it "is a management
tool that can be used to gauge the loyalty of a firm's customer relationships."
}
\examples{
nps_question <- sample(10, 100, replace = TRUE)
nps_date <- rep(seq.Date(from = as.Date("2019-01-01"), to = as.Date("2019-01-10"), by = "day"), 10)
nps_group <- rep(c("a", "b", "c", "d"), 25)
df <- data.frame(nps_question, nps_date, nps_group)
nps_calc(df, nps_group)
}
