% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round-by.R
\name{round_by}
\alias{round_by}
\title{Rounding by a specific interval.}
\usage{
round_by(x, by = 1, method = c("round", "ceiling", "floor"), include0 = TRUE)
}
\arguments{
\item{x}{A number or vector to round.}

\item{by}{The number by which to round}

\item{method}{An option to explicitly specify automatic rounding, ceiling, or floor}

\item{include0}{If \code{FALSE} replaces \code{0} with \code{by}}
}
\value{
A vector of \code{doubles} of the same length of \code{x}
}
\description{
Rounds a number or vector of numbers by another
}
\examples{
x <- seq(1, 13, by = 4/3)

cbind(
  x,
  by_1 = round_by(x, 1),
  by_2 = round_by(x, 2),
  by_3 = round_by(x, 3)
)
}
